/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.formats.newick;

import info.bioinfweb.commons.log.ApplicationLogger;
import info.bioinfweb.jphyloio.AbstractEventWriter;
import info.bioinfweb.jphyloio.ReadWriteParameterMap;
import info.bioinfweb.jphyloio.dataadapters.ObjectListDataAdapter;
import info.bioinfweb.jphyloio.dataadapters.TreeNetworkDataAdapter;
import info.bioinfweb.jphyloio.events.EdgeEvent;
import info.bioinfweb.jphyloio.events.NodeEvent;
import info.bioinfweb.jphyloio.formats.newick.NewickConstants;
import info.bioinfweb.jphyloio.formats.newick.NewickNodeEdgeEventReceiver;
import info.bioinfweb.jphyloio.formats.newick.NewickScanner;
import info.bioinfweb.jphyloio.formats.newick.NewickWriterNodeLabelProcessor;
import info.bioinfweb.jphyloio.formats.text.TextWriterStreamDataProvider;
import info.bioinfweb.jphyloio.utils.TopoplogicalNodeInfo;
import info.bioinfweb.jphyloio.utils.TreeTopologyExtractor;
import java.io.IOException;
import java.util.Iterator;

public class NewickStringWriter
implements NewickConstants {
    private TextWriterStreamDataProvider<?> streamDataProvider;
    private TreeNetworkDataAdapter tree;
    private ObjectListDataAdapter<EdgeEvent> edges;
    private ObjectListDataAdapter<NodeEvent> nodes;
    private TreeTopologyExtractor topologyExtractor;
    private NewickWriterNodeLabelProcessor nodeLabelProcessor;
    private ReadWriteParameterMap parameters;

    public NewickStringWriter(TextWriterStreamDataProvider<?> textWriterStreamDataProvider, TreeNetworkDataAdapter treeNetworkDataAdapter, NewickWriterNodeLabelProcessor newickWriterNodeLabelProcessor, ReadWriteParameterMap readWriteParameterMap) {
        this.streamDataProvider = textWriterStreamDataProvider;
        this.tree = treeNetworkDataAdapter;
        this.nodeLabelProcessor = newickWriterNodeLabelProcessor;
        this.parameters = readWriteParameterMap;
    }

    public static boolean isFreeNameCharForWriting(char c) {
        return NewickScanner.isFreeNameChar(c) && c != '\'' && c != '\"';
    }

    private static boolean isFreeName(String string) {
        if (string.length() == 0) {
            return true;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (NewickStringWriter.isFreeNameCharForWriting(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String formatToken(String string, char c) {
        CharSequence charSequence;
        boolean bl = string.contains("_");
        if (!bl && NewickStringWriter.isFreeName(string)) {
            return string;
        }
        if (!bl && NewickStringWriter.isFreeName((String)(charSequence = string.replace(' ', '_')))) {
            return charSequence;
        }
        charSequence = new StringBuffer(string.length() * 2);
        ((StringBuffer)charSequence).append(c);
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == c) {
                ((StringBuffer)charSequence).append(c);
            }
            ((StringBuffer)charSequence).append(string.charAt(i));
        }
        ((StringBuffer)charSequence).append(c);
        return ((StringBuffer)charSequence).toString();
    }

    private void writeSubtree(String string) throws IOException {
        TopoplogicalNodeInfo topoplogicalNodeInfo = this.topologyExtractor.getIDToNodeInfoMap().get(string);
        NewickNodeEdgeEventReceiver newickNodeEdgeEventReceiver = new NewickNodeEdgeEventReceiver(this.streamDataProvider, this.parameters);
        this.edges.writeContentData(this.parameters, newickNodeEdgeEventReceiver, topoplogicalNodeInfo.getAfferentBranchID());
        Iterator<String> iterator = topoplogicalNodeInfo.getChildNodeIDs().iterator();
        if (iterator.hasNext()) {
            this.streamDataProvider.getWriter().write(40);
            this.writeSubtree(iterator.next());
            while (iterator.hasNext()) {
                this.streamDataProvider.getWriter().write(", ");
                this.writeSubtree(iterator.next());
            }
            this.streamDataProvider.getWriter().write(41);
        }
        NewickNodeEdgeEventReceiver newickNodeEdgeEventReceiver2 = new NewickNodeEdgeEventReceiver(this.streamDataProvider, this.parameters);
        this.nodes.writeContentData(this.parameters, newickNodeEdgeEventReceiver2, string);
        this.streamDataProvider.getWriter().write(NewickStringWriter.formatToken(this.nodeLabelProcessor.createNodeName(this.tree.getNodes(this.parameters).getObjectStartEvent(this.parameters, string)), '\''));
        newickNodeEdgeEventReceiver2.writeMetadata();
        newickNodeEdgeEventReceiver2.writeComments();
        if (this.edges.getObjectStartEvent(this.parameters, topoplogicalNodeInfo.getAfferentBranchID()).hasLength()) {
            this.streamDataProvider.getWriter().write(58);
            this.streamDataProvider.getWriter().write(Double.toString(this.edges.getObjectStartEvent(this.parameters, topoplogicalNodeInfo.getAfferentBranchID()).getLength()));
        } else if (!newickNodeEdgeEventReceiver2.hasMetadataToWrite() && newickNodeEdgeEventReceiver.hasMetadataToWrite()) {
            this.streamDataProvider.getWriter().write(91);
            this.streamDataProvider.getWriter().write(38);
            this.streamDataProvider.getWriter().write(93);
        }
        newickNodeEdgeEventReceiver.writeMetadata();
        newickNodeEdgeEventReceiver.writeComments();
    }

    private void writeRootedInformation() throws IOException {
        this.streamDataProvider.getWriter().write(91);
        if (this.nodes.getObjectStartEvent(this.parameters, this.topologyExtractor.getPaintStartID()).isRootNode()) {
            this.streamDataProvider.getWriter().write("&r".toUpperCase());
        } else {
            this.streamDataProvider.getWriter().write("&u".toUpperCase());
        }
        this.streamDataProvider.getWriter().write(93);
        this.streamDataProvider.getWriter().write(" ");
    }

    public void write() throws IOException {
        ApplicationLogger applicationLogger = this.parameters.getLogger();
        if (this.tree.isTree(this.parameters)) {
            this.edges = this.tree.getEdges(this.parameters);
            this.nodes = this.tree.getNodes(this.parameters);
            this.topologyExtractor = new TreeTopologyExtractor(this.tree, this.parameters);
            this.writeRootedInformation();
            this.writeSubtree(this.topologyExtractor.getPaintStartID());
            this.streamDataProvider.getWriter().write(59);
            AbstractEventWriter.writeLineBreak(this.streamDataProvider.getWriter(), this.parameters);
        } else {
            applicationLogger.addWarning("A provided network definition was ignored, because the Newick/NHX format only supports trees.");
        }
    }
}

