/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.formats.newick;

import info.bioinfweb.commons.io.StreamLocationProvider;
import info.bioinfweb.commons.io.W3CXSConstants;
import info.bioinfweb.jphyloio.ReadWriteConstants;
import info.bioinfweb.jphyloio.events.CommentEvent;
import info.bioinfweb.jphyloio.events.ConcreteJPhyloIOEvent;
import info.bioinfweb.jphyloio.events.EdgeEvent;
import info.bioinfweb.jphyloio.events.JPhyloIOEvent;
import info.bioinfweb.jphyloio.events.LabeledIDEvent;
import info.bioinfweb.jphyloio.events.NodeEvent;
import info.bioinfweb.jphyloio.events.meta.LiteralContentSequenceType;
import info.bioinfweb.jphyloio.events.meta.LiteralMetadataContentEvent;
import info.bioinfweb.jphyloio.events.meta.LiteralMetadataEvent;
import info.bioinfweb.jphyloio.events.meta.URIOrStringIdentifier;
import info.bioinfweb.jphyloio.events.type.EventContentType;
import info.bioinfweb.jphyloio.events.type.EventTopologyType;
import info.bioinfweb.jphyloio.exception.JPhyloIOReaderException;
import info.bioinfweb.jphyloio.formats.NodeEdgeInfo;
import info.bioinfweb.jphyloio.formats.newick.HotCommentDataReader;
import info.bioinfweb.jphyloio.formats.newick.NewickConstants;
import info.bioinfweb.jphyloio.formats.newick.NewickReaderNodeLabelProcessor;
import info.bioinfweb.jphyloio.formats.newick.NewickScanner;
import info.bioinfweb.jphyloio.formats.newick.NewickToken;
import info.bioinfweb.jphyloio.formats.newick.NewickTokenType;
import info.bioinfweb.jphyloio.formats.text.TextReaderStreamDataProvider;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Stack;
import java.util.regex.Pattern;

public class NewickStringReader
implements ReadWriteConstants,
NewickConstants {
    private static final Pattern HOT_COMMENT_PATTERN = Pattern.compile("\\s*\\&.*");
    private static final int NO_HOT_COMMENT_READ = -2;
    private static final int ONE_HOT_COMMENT_READ = -1;
    private TextReaderStreamDataProvider<?> streamDataProvider;
    private boolean currentTreeRooted = false;
    private String treeID;
    private String treeLabel;
    private boolean expectENewick;
    private NewickReaderNodeLabelProcessor nodeLabelProcessor;
    private NewickScanner scanner;
    private Stack<Queue<NodeEdgeInfo>> passedSubnodes;
    private Map<Long, String> networkNodeLabelToIDMap = new HashMap<Long, String>();
    private HotCommentDataReader hotCommentDataReader = new HotCommentDataReader();
    private boolean isInTree = false;
    private boolean afterTree = false;

    public NewickStringReader(TextReaderStreamDataProvider<?> textReaderStreamDataProvider, String string, String string2, NewickReaderNodeLabelProcessor newickReaderNodeLabelProcessor, boolean bl) {
        if (textReaderStreamDataProvider == null) {
            throw new NullPointerException("streamDataProvider must not be null.");
        }
        if (newickReaderNodeLabelProcessor == null) {
            throw new NullPointerException("nodeLabelProcessor must not be null.");
        }
        this.streamDataProvider = textReaderStreamDataProvider;
        this.treeID = string == null ? "tree" + textReaderStreamDataProvider.getIDManager().createNewID() : string;
        this.treeLabel = string2;
        this.nodeLabelProcessor = newickReaderNodeLabelProcessor;
        this.expectENewick = bl;
        this.scanner = new NewickScanner(textReaderStreamDataProvider.getDataReader(), string2 == null);
        this.passedSubnodes = new Stack();
    }

    private EventContentType getTreeContentType() {
        if (this.expectENewick) {
            return EventContentType.NETWORK;
        }
        return EventContentType.TREE;
    }

    private boolean isHotComment(String string) {
        return HOT_COMMENT_PATTERN.matcher(string).matches();
    }

    private Collection<JPhyloIOEvent> createMetaAndCommentEvents(List<NewickToken> list, boolean bl) throws IOException {
        ArrayList<JPhyloIOEvent> arrayList = new ArrayList<JPhyloIOEvent>();
        for (NewickToken newickToken : list) {
            if (newickToken.getText().trim().startsWith("&")) {
                try {
                    this.hotCommentDataReader.read(newickToken.getText(), this.streamDataProvider, arrayList, bl);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    arrayList.add(new CommentEvent(newickToken.getText(), false));
                }
                continue;
            }
            arrayList.add(new CommentEvent(newickToken.getText(), false));
        }
        return arrayList;
    }

    private List<NewickToken>[] collectNodeEdgeTokens() throws IOException {
        ArrayList<NewickToken> arrayList = new ArrayList<NewickToken>();
        ArrayList<NewickToken> arrayList2 = new ArrayList<NewickToken>();
        if (this.scanner.hasMoreTokens()) {
            boolean bl = true;
            boolean bl2 = true;
            int n = -2;
            NewickToken newickToken = this.scanner.peek();
            NewickTokenType newickTokenType = newickToken.getType();
            while (newickToken != null && (bl && newickTokenType.equals((Object)NewickTokenType.NAME) || bl2 && newickTokenType.equals((Object)NewickTokenType.LENGTH) || newickTokenType.equals((Object)NewickTokenType.COMMENT))) {
                switch (newickTokenType) {
                    case NAME: {
                        arrayList.add(this.scanner.nextToken());
                        bl = false;
                        break;
                    }
                    case LENGTH: {
                        arrayList2.add(this.scanner.nextToken());
                        bl2 = false;
                        break;
                    }
                    case COMMENT: {
                        if (bl2) {
                            if (this.isHotComment(newickToken.getText())) {
                                if (n == -2) {
                                    n = -1;
                                } else if (n == -1) {
                                    n = arrayList.size();
                                }
                            }
                            arrayList.add(newickToken);
                        } else {
                            arrayList2.add(newickToken);
                        }
                        this.scanner.nextToken();
                        break;
                    }
                    default: {
                        throw new InternalError("Impossible case");
                    }
                }
                if (this.scanner.hasMoreTokens()) {
                    newickToken = this.scanner.peek();
                    newickTokenType = newickToken.getType();
                    continue;
                }
                newickToken = null;
            }
            if (bl2 && n > 0) {
                List list = arrayList.subList(n, arrayList.size());
                arrayList2.addAll(list);
                list.clear();
            }
        }
        return new List[]{arrayList, arrayList2};
    }

    private String createNodeID() {
        return "n" + this.streamDataProvider.getIDManager().createNewID();
    }

    private ENewickNodeLabel splitENewickNodeLabel(String string) {
        int n;
        ENewickNodeLabel eNewickNodeLabel = new ENewickNodeLabel();
        String[] stringArray = string.split("\\#");
        eNewickNodeLabel.label = stringArray[0];
        StringBuilder stringBuilder = new StringBuilder();
        for (n = stringArray[1].length() - 1; n >= 0 && Character.isDigit(stringArray[1].charAt(n)); --n) {
            stringBuilder.insert(0, stringArray[1].charAt(n));
        }
        eNewickNodeLabel.index = Long.parseLong(stringBuilder.toString());
        eNewickNodeLabel.edgeType = stringArray[1].substring(0, n + 1);
        return eNewickNodeLabel;
    }

    private void addENewickEdgeTypeEvents(Collection<JPhyloIOEvent> collection, String string) {
        if (string != null && !"".equals(string)) {
            collection.add(new LiteralMetadataEvent("meta" + this.streamDataProvider.getIDManager().createNewID(), null, new URIOrStringIdentifier(null, PREDICATE_E_NEWICK_EDGE_TYPE), new URIOrStringIdentifier(null, W3CXSConstants.DATA_TYPE_NAME), LiteralContentSequenceType.SIMPLE));
            collection.add(new LiteralMetadataContentEvent((Object)string, string));
            collection.add(ConcreteJPhyloIOEvent.createEndEvent(EventContentType.LITERAL_META));
        }
    }

    private String readNode(boolean bl) throws IOException {
        NewickToken newickToken;
        if (this.scanner.hasMoreTokens()) {
            newickToken = this.scanner.peek();
        } else if (this.passedSubnodes.size() == 1) {
            newickToken = new NewickToken(NewickTokenType.TERMNINAL_SYMBOL, (StreamLocationProvider)this.streamDataProvider.getDataReader());
        } else {
            throw new JPhyloIOReaderException("Unexpected end of file inside a Newick tree definition.", (StreamLocationProvider)this.streamDataProvider.getDataReader());
        }
        if (newickToken.getType().equals((Object)NewickTokenType.SUBTREE_START)) {
            return null;
        }
        List<NewickToken>[] listArray = this.collectNodeEdgeTokens();
        String string = null;
        if (!listArray[0].isEmpty() && listArray[0].get(0).getType().equals((Object)NewickTokenType.NAME)) {
            string = listArray[0].get(0).getText();
            listArray[0].remove(0);
        }
        Collection<JPhyloIOEvent> collection = this.createMetaAndCommentEvents(listArray[0], true);
        double d = Double.NaN;
        if (!listArray[1].isEmpty() && listArray[1].get(0).getType().equals((Object)NewickTokenType.LENGTH)) {
            d = listArray[1].get(0).getLength();
            listArray[1].remove(0);
        }
        Collection<JPhyloIOEvent> collection2 = this.createMetaAndCommentEvents(listArray[1], false);
        boolean bl2 = true;
        String string2 = this.nodeLabelProcessor.processLabel(string, bl);
        String string3 = null;
        if (this.expectENewick && string2.contains("#")) {
            ENewickNodeLabel eNewickNodeLabel = this.splitENewickNodeLabel(string2);
            string2 = eNewickNodeLabel.label;
            string3 = this.networkNodeLabelToIDMap.get(eNewickNodeLabel.index);
            if (string3 == null) {
                string3 = this.createNodeID();
                this.networkNodeLabelToIDMap.put(eNewickNodeLabel.index, string3);
            } else {
                bl2 = false;
            }
            this.addENewickEdgeTypeEvents(collection2, eNewickNodeLabel.edgeType);
        } else {
            string3 = this.createNodeID();
        }
        this.passedSubnodes.peek().add(new NodeEdgeInfo(string3, d, null, collection2));
        if (bl2) {
            this.streamDataProvider.getCurrentEventCollection().add(new NodeEvent(string3, string2, this.nodeLabelProcessor.getLinkedOTUID(string2), this.currentTreeRooted && this.passedSubnodes.size() == 1));
            this.streamDataProvider.getCurrentEventCollection().addAll(collection);
            this.streamDataProvider.getCurrentEventCollection().add(new ConcreteJPhyloIOEvent(EventContentType.NODE, EventTopologyType.END));
        } else if (!collection.isEmpty()) {
            this.streamDataProvider.getParameters().getLogger().addWarning("Some metadata in hot comments attached to an eNewick network node was ignored. Note that JPhyloIO currently only handles hot comments attached to the first (left most) appearance of a network node.");
        }
        return string3;
    }

    private void addEdgeEvents(String string, Queue<NodeEdgeInfo> queue) {
        while (!queue.isEmpty()) {
            NodeEdgeInfo nodeEdgeInfo = queue.poll();
            this.streamDataProvider.getCurrentEventCollection().add(new EdgeEvent("e" + this.streamDataProvider.getIDManager().createNewID(), null, string, nodeEdgeInfo.getID(), nodeEdgeInfo.getLength()));
            this.streamDataProvider.getCurrentEventCollection().addAll(nodeEdgeInfo.getNestedEdgeEvents());
            this.streamDataProvider.getCurrentEventCollection().add(new ConcreteJPhyloIOEvent(string == null ? EventContentType.ROOT_EDGE : EventContentType.EDGE, EventTopologyType.END));
        }
    }

    private void addCommentEvent(NewickToken newickToken) {
        this.streamDataProvider.getCurrentEventCollection().add(new CommentEvent(newickToken.getText(), false));
    }

    private void endTree() {
        this.addEdgeEvents(null, this.passedSubnodes.pop());
        this.streamDataProvider.getCurrentEventCollection().add(ConcreteJPhyloIOEvent.createEndEvent(this.getTreeContentType()));
        this.isInTree = false;
        this.currentTreeRooted = false;
    }

    private void processTree() throws IOException {
        block8: while (this.streamDataProvider.getCurrentEventCollection().isEmpty()) {
            if (!this.scanner.hasMoreTokens()) {
                if (this.passedSubnodes.size() == 1) {
                    this.endTree();
                    continue;
                }
                throw new JPhyloIOReaderException("Unexpected end of file inside a subtree defintion.", (StreamLocationProvider)this.streamDataProvider.getDataReader());
            }
            NewickToken newickToken = this.scanner.nextToken();
            switch (newickToken.getType()) {
                case SUBTREE_START: {
                    this.passedSubnodes.add(new ArrayDeque());
                }
                case ELEMENT_SEPARATOR: {
                    this.readNode(false);
                    continue block8;
                }
                case SUBTREE_END: {
                    if (this.scanner.hasMoreTokens() && this.scanner.peek().getType().equals((Object)NewickTokenType.SUBTREE_START)) {
                        throw new JPhyloIOReaderException("Unexpected Newick token \"" + (Object)((Object)NewickTokenType.SUBTREE_START) + "\"", (StreamLocationProvider)this.scanner.peek().getLocation());
                    }
                    Queue<NodeEdgeInfo> queue = this.passedSubnodes.pop();
                    this.addEdgeEvents(this.readNode(true), queue);
                    continue block8;
                }
                case TERMNINAL_SYMBOL: {
                    this.endTree();
                    continue block8;
                }
                case ROOTED_COMMAND: {
                    this.streamDataProvider.getParameters().getLogger().addWarning("More than one rooting hot comment was found. All but the first one are treated as ordinary comments.");
                }
                case COMMENT: {
                    this.addCommentEvent(newickToken);
                    continue block8;
                }
            }
            throw new JPhyloIOReaderException("Unexpected Newick token \"" + (Object)((Object)newickToken.getType()) + "\"", (StreamLocationProvider)newickToken.getLocation());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean addNextEvents() throws IOException {
        boolean bl = this.scanner.hasMoreTokens();
        if (this.afterTree) {
            if (this.scanner.hasMoreTokens()) {
                NewickToken newickToken = this.scanner.nextToken();
                if (newickToken.getType().equals((Object)NewickTokenType.COMMENT)) {
                    this.addCommentEvent(newickToken);
                    return bl;
                } else {
                    if (!newickToken.getType().equals((Object)NewickTokenType.TERMNINAL_SYMBOL)) throw new JPhyloIOReaderException("Tree end expected, but found " + (Object)((Object)newickToken.getType()) + " \"" + newickToken.getText() + "\".", (StreamLocationProvider)this.streamDataProvider.getDataReader());
                    this.afterTree = false;
                    this.endTree();
                }
                return bl;
            } else {
                this.endTree();
            }
            return bl;
        } else if (!this.isInTree) {
            if (!bl) return bl;
            NewickTokenType newickTokenType = this.scanner.peek().getType();
            if (NewickTokenType.COMMENT.equals((Object)newickTokenType)) {
                this.addCommentEvent(this.scanner.nextToken());
                return bl;
            } else {
                this.streamDataProvider.getCurrentEventCollection().add(new LabeledIDEvent(this.getTreeContentType(), this.treeID, this.treeLabel));
                if (NewickTokenType.ROOTED_COMMAND.equals((Object)newickTokenType) || NewickTokenType.UNROOTED_COMMAND.equals((Object)newickTokenType)) {
                    this.currentTreeRooted = NewickTokenType.ROOTED_COMMAND.equals((Object)newickTokenType);
                    this.scanner.nextToken();
                }
                this.passedSubnodes.add(new ArrayDeque());
                if (this.scanner.hasMoreTokens()) {
                    newickTokenType = this.scanner.peek().getType();
                    if (newickTokenType.equals((Object)NewickTokenType.NAME) || newickTokenType.equals((Object)NewickTokenType.LENGTH)) {
                        this.readNode(false);
                        this.afterTree = true;
                        return true;
                    }
                    if (newickTokenType.equals((Object)NewickTokenType.COMMENT)) {
                        return true;
                    }
                }
                this.isInTree = true;
            }
            return bl;
        } else {
            this.processTree();
            return true;
        }
    }

    private static class ENewickNodeLabel {
        public String label = "";
        public long index = -1L;
        public String edgeType = "";

        private ENewickNodeLabel() {
        }
    }
}

