/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.formats.newick;

import info.bioinfweb.commons.io.PeekReader;
import info.bioinfweb.commons.io.StreamLocation;
import info.bioinfweb.commons.io.StreamLocationProvider;
import info.bioinfweb.jphyloio.exception.JPhyloIOReaderException;
import info.bioinfweb.jphyloio.formats.newick.NewickConstants;
import info.bioinfweb.jphyloio.formats.newick.NewickToken;
import info.bioinfweb.jphyloio.formats.newick.NewickTokenType;
import java.io.IOException;
import java.util.NoSuchElementException;

public class NewickScanner
implements NewickConstants {
    private PeekReader reader;
    private boolean readSequence;
    private NewickToken next = null;
    private NewickToken previous = null;
    private boolean beforeFirstAccess = true;
    private boolean branchLengthExpected = false;

    public NewickScanner(PeekReader peekReader, boolean bl) {
        this.reader = peekReader;
        this.readSequence = bl;
    }

    public static boolean isCharAfterLength(char c) {
        return Character.isWhitespace(c) || c == ',' || c == ')' || c == '[' || c == ';';
    }

    public static boolean isFreeNameChar(char c) {
        return c != ')' && c != ':' && c != ',' && c != '[' && c != ';' && !Character.isWhitespace(c);
    }

    private NewickToken readDelimitedName(char c) throws IOException {
        this.reader.read();
        StringBuilder stringBuilder = new StringBuilder();
        while (true) {
            if (this.reader.peek() != -1 && this.reader.peekChar() != c) {
                stringBuilder.append(this.reader.readChar());
                continue;
            }
            if (this.reader.peek(1) != -1 && this.reader.peekChar(1) == c) {
                stringBuilder.append(c);
                this.reader.read();
                this.reader.read();
            }
            if (this.reader.peek() == -1 || this.reader.peekChar() == c) break;
        }
        if (this.reader.peek() == -1) {
            throw new JPhyloIOReaderException("Unterminated Newick token.", (StreamLocationProvider)this.reader);
        }
        this.reader.read();
        NewickToken newickToken = new NewickToken(NewickTokenType.NAME, (StreamLocationProvider)this.reader);
        newickToken.setText(stringBuilder.toString());
        newickToken.setDelimited(true);
        return newickToken;
    }

    private NewickToken readFreeName() throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.reader.readChar());
        while (this.reader.peek() != -1 && NewickScanner.isFreeNameChar(this.reader.peekChar())) {
            char c = this.reader.readChar();
            if (c == '_') {
                stringBuilder.append(' ');
                continue;
            }
            stringBuilder.append(c);
        }
        if (this.reader.peek() == -1) {
            throw new JPhyloIOReaderException("Unterminated Newick name.", (StreamLocationProvider)this.reader);
        }
        return new NewickToken((StreamLocationProvider)this.reader, stringBuilder.toString(), false);
    }

    private NewickToken readBranchLength() throws IOException {
        double d;
        this.reader.readRegExp("\\s*", true);
        if (this.reader.peek() == -1) {
            throw new JPhyloIOReaderException("Unexpected end of file in a Newick branch length definition.", (StreamLocationProvider)this.reader);
        }
        StreamLocation streamLocation = new StreamLocation((StreamLocationProvider)this.reader);
        if (this.reader.peekChar() == '[') {
            return this.readComment();
        }
        StringBuilder stringBuilder = new StringBuilder();
        while (this.reader.peek() != -1 && !NewickScanner.isCharAfterLength(this.reader.peekChar())) {
            stringBuilder.append(this.reader.readChar());
        }
        try {
            d = Double.parseDouble(stringBuilder.toString());
        }
        catch (NumberFormatException numberFormatException) {
            throw new JPhyloIOReaderException("\"" + stringBuilder + "\" is not a valid Newick branch length.", (StreamLocationProvider)streamLocation, (Throwable)numberFormatException);
        }
        NewickToken newickToken = new NewickToken(NewickTokenType.LENGTH, (StreamLocationProvider)streamLocation);
        newickToken.setLength(d);
        this.branchLengthExpected = false;
        return newickToken;
    }

    private NewickToken readComment() throws IOException {
        StreamLocation streamLocation = new StreamLocation((StreamLocationProvider)this.reader);
        this.reader.read();
        StringBuilder stringBuilder = new StringBuilder();
        while (this.reader.peek() != -1 && this.reader.peekChar() != ']') {
            stringBuilder.append(this.reader.readChar());
        }
        if (this.reader.peek() == -1) {
            throw new JPhyloIOReaderException("Unexpected end of file inside a Newick comment.", (StreamLocationProvider)this.reader);
        }
        this.reader.read();
        String string = stringBuilder.toString();
        String string2 = string.trim().toLowerCase();
        if (string2.equals("&u")) {
            return new NewickToken(NewickTokenType.UNROOTED_COMMAND, (StreamLocationProvider)streamLocation);
        }
        if (string2.equals("&r")) {
            return new NewickToken(NewickTokenType.ROOTED_COMMAND, (StreamLocationProvider)streamLocation);
        }
        NewickToken newickToken = new NewickToken(NewickTokenType.COMMENT, (StreamLocationProvider)streamLocation);
        newickToken.setText(string);
        return newickToken;
    }

    private NewickToken readNextToken() throws IOException {
        this.reader.readRegExp("\\s*", true);
        if (this.reader.peek() == -1) {
            return null;
        }
        if (this.branchLengthExpected) {
            return this.readBranchLength();
        }
        switch (this.reader.peekChar()) {
            case '(': {
                this.reader.read();
                return new NewickToken(NewickTokenType.SUBTREE_START, (StreamLocationProvider)this.reader);
            }
            case ')': {
                this.reader.read();
                return new NewickToken(NewickTokenType.SUBTREE_END, (StreamLocationProvider)this.reader);
            }
            case ':': {
                this.branchLengthExpected = true;
                this.reader.read();
                return this.readBranchLength();
            }
            case '\"': 
            case '\'': {
                return this.readDelimitedName(this.reader.peekChar());
            }
            case ';': {
                this.reader.read();
                return new NewickToken(NewickTokenType.TERMNINAL_SYMBOL, (StreamLocationProvider)this.reader);
            }
            case ',': {
                this.reader.read();
                return new NewickToken(NewickTokenType.ELEMENT_SEPARATOR, (StreamLocationProvider)this.reader);
            }
            case '[': {
                return this.readComment();
            }
        }
        if (NewickScanner.isFreeNameChar(this.reader.peekChar())) {
            return this.readFreeName();
        }
        throw new JPhyloIOReaderException("Unexpected token '" + this.reader.peekChar() + "'.", (StreamLocationProvider)this.reader);
    }

    public NewickToken peek() throws IOException {
        if (!this.hasMoreTokens()) {
            throw new NoSuchElementException("The end of the document was already reached.");
        }
        return this.next;
    }

    private void ensureFirstEvent() throws IOException {
        if (this.beforeFirstAccess) {
            this.next = this.readNextToken();
            this.beforeFirstAccess = false;
        }
    }

    public boolean hasMoreTokens() throws IOException {
        this.ensureFirstEvent();
        return this.next != null;
    }

    public NewickToken nextToken() throws IOException {
        if (!this.hasMoreTokens()) {
            throw new NoSuchElementException("The end of the document was already reached.");
        }
        this.previous = this.next;
        this.next = !this.readSequence && NewickTokenType.TERMNINAL_SYMBOL.equals((Object)this.previous.getType()) ? null : this.readNextToken();
        return this.previous;
    }
}

