/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.formats.newick;

import info.bioinfweb.jphyloio.ReadWriteParameterMap;
import info.bioinfweb.jphyloio.dataadapters.implementations.receivers.BasicEventReceiver;
import info.bioinfweb.jphyloio.events.CommentEvent;
import info.bioinfweb.jphyloio.events.JPhyloIOEvent;
import info.bioinfweb.jphyloio.events.meta.LiteralContentSequenceType;
import info.bioinfweb.jphyloio.events.meta.LiteralMetadataContentEvent;
import info.bioinfweb.jphyloio.events.meta.LiteralMetadataEvent;
import info.bioinfweb.jphyloio.events.meta.URIOrStringIdentifier;
import info.bioinfweb.jphyloio.events.type.EventContentType;
import info.bioinfweb.jphyloio.exception.IllegalEventException;
import info.bioinfweb.jphyloio.exception.InconsistentAdapterDataException;
import info.bioinfweb.jphyloio.exception.JPhyloIOWriterException;
import info.bioinfweb.jphyloio.formats.newick.NewickConstants;
import info.bioinfweb.jphyloio.formats.text.TextWriterStreamDataProvider;
import info.bioinfweb.jphyloio.objecttranslation.implementations.ListTranslator;
import info.bioinfweb.jphyloio.objecttranslation.implementations.SimpleValueTranslator;
import info.bioinfweb.jphyloio.objecttranslation.implementations.StringTranslator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public class NewickNodeEdgeEventReceiver<E extends JPhyloIOEvent>
extends BasicEventReceiver
implements NewickConstants {
    public static final char STRING_DELEMITER_REPLACEMENT = '\'';
    private List<Metadata> metadataList = new ArrayList<Metadata>();
    private List<CommentEvent> commentEvents = new ArrayList<CommentEvent>();
    private boolean ignoredXMLMetadata = false;
    private StringBuilder currentLiteralValue = new StringBuilder();
    private ListTranslator listTranslator = new ListTranslator();
    private StringTranslator stringTranslator = new StringTranslator();

    public NewickNodeEdgeEventReceiver(TextWriterStreamDataProvider<?> textWriterStreamDataProvider, ReadWriteParameterMap readWriteParameterMap) {
        super(textWriterStreamDataProvider, readWriteParameterMap);
    }

    public TextWriterStreamDataProvider getStreamDataProvider() {
        return (TextWriterStreamDataProvider)super.getStreamDataProvider();
    }

    public boolean isIgnoredXMLMetadata() {
        return this.ignoredXMLMetadata;
    }

    private void clearCurrentLiteralValue() {
        this.currentLiteralValue.delete(0, this.currentLiteralValue.length());
    }

    public void clear() {
        this.commentEvents.clear();
        this.ignoredXMLMetadata = false;
        this.clearCurrentLiteralValue();
    }

    @Override
    protected void handleLiteralMetaStart(LiteralMetadataEvent literalMetadataEvent) throws IOException, XMLStreamException {
        if (literalMetadataEvent.getSequenceType().equals((Object)LiteralContentSequenceType.SIMPLE)) {
            String string = literalMetadataEvent.getPredicate().getStringRepresentation();
            if (string == null) {
                if (literalMetadataEvent.getPredicate().getURI() == null) {
                    throw new JPhyloIOWriterException("A literal metadata event without predicate or alternative string representation was encountered.");
                }
                string = literalMetadataEvent.getPredicate().getURI().getLocalPart();
            }
            this.metadataList.add(new Metadata(string, literalMetadataEvent.getOriginalType()));
        } else {
            this.ignoredXMLMetadata = true;
        }
    }

    @Override
    protected void handleLiteralContentMeta(LiteralMetadataContentEvent literalMetadataContentEvent) throws IOException, XMLStreamException {
        if (this.metadataList.isEmpty()) {
            throw new InternalError("No metadata entry was add for the parent literal meta event.");
        }
        if (literalMetadataContentEvent.isContinuedInNextEvent() || this.currentLiteralValue.length() > 0) {
            if (!literalMetadataContentEvent.hasStringValue() || literalMetadataContentEvent.hasObjectValue()) {
                throw new IllegalEventException("A literal metadata content event with null as its string representation and/or a non null object value was encountered, although it specifies to be continued or followes upon a continued string event.", this, this.getParentEvent(), literalMetadataContentEvent);
            }
            this.currentLiteralValue.append(literalMetadataContentEvent.getStringValue());
        }
        if (!literalMetadataContentEvent.isContinuedInNextEvent()) {
            String string;
            Metadata metadata = this.metadataList.get(this.metadataList.size() - 1);
            if (!literalMetadataContentEvent.hasStringValue()) {
                SimpleValueTranslator simpleValueTranslator = null;
                if (metadata.originalType != null) {
                    simpleValueTranslator = this.getParameterMap().getObjectTranslatorFactory().getDefaultTranslator(metadata.originalType);
                }
                if (simpleValueTranslator == null) {
                    simpleValueTranslator = literalMetadataContentEvent.getObjectValue() instanceof Collection ? this.listTranslator : this.stringTranslator;
                }
                string = simpleValueTranslator.javaToRepresentation(literalMetadataContentEvent.getObjectValue(), this.getStreamDataProvider());
            } else {
                string = this.currentLiteralValue.length() > 0 ? this.currentLiteralValue.toString() : literalMetadataContentEvent.getStringValue();
                if (!(literalMetadataContentEvent.getObjectValue() instanceof Number)) {
                    string = '\'' + string.replaceAll("\\'", "''") + '\'';
                }
            }
            if (metadata.value != null) {
                throw new IllegalEventException("An additional literal metadata content event was encountered, although the previous content event was a terminating event.", this, this.getParentEvent(), literalMetadataContentEvent);
            }
            metadata.value = string;
            this.clearCurrentLiteralValue();
        }
    }

    @Override
    protected void handleMetaEndEvent(JPhyloIOEvent jPhyloIOEvent) throws IOException, XMLStreamException {
        if (jPhyloIOEvent.getType().getContentType().equals((Object)EventContentType.LITERAL_META) && this.currentLiteralValue.length() > 0) {
            throw new InconsistentAdapterDataException("A literal meta end event was encounterd, although the last literal meta content event was marked to be continued in a subsequent event.");
        }
    }

    @Override
    protected void handleComment(CommentEvent commentEvent) {
        this.commentEvents.add(commentEvent.asCommentEvent());
    }

    public boolean hasMetadataToWrite() {
        return !this.metadataList.isEmpty();
    }

    public void writeMetadata() throws IOException {
        if (this.hasMetadataToWrite()) {
            this.getStreamDataProvider().getWriter().write(91);
            this.getStreamDataProvider().getWriter().write(38);
            Iterator<Metadata> iterator = this.metadataList.iterator();
            while (iterator.hasNext()) {
                Metadata metadata = iterator.next();
                this.getStreamDataProvider().getWriter().write(metadata.key);
                this.getStreamDataProvider().getWriter().write(61);
                if (metadata.value != null) {
                    this.getStreamDataProvider().getWriter().write(metadata.value);
                }
                if (!iterator.hasNext()) continue;
                this.getStreamDataProvider().getWriter().write(44);
                this.getStreamDataProvider().getWriter().write(32);
            }
            this.getStreamDataProvider().getWriter().write(93);
        }
    }

    public void writeComments() throws IOException {
        Iterator<CommentEvent> iterator = this.commentEvents.iterator();
        while (iterator.hasNext()) {
            this.getStreamDataProvider().getWriter().write(91);
            CommentEvent commentEvent = iterator.next();
            this.getStreamDataProvider().getWriter().write(commentEvent.getContent());
            while (commentEvent.isContinuedInNextEvent() && iterator.hasNext()) {
                commentEvent = iterator.next();
                this.getStreamDataProvider().getWriter().write(commentEvent.getContent());
            }
            this.getStreamDataProvider().getWriter().write(93);
        }
    }

    private static class Metadata {
        public String key;
        public String value = null;
        public QName originalType = null;

        public Metadata(String string, URIOrStringIdentifier uRIOrStringIdentifier) {
            this.key = string;
            if (uRIOrStringIdentifier != null) {
                this.originalType = uRIOrStringIdentifier.getURI();
            }
        }
    }
}

