/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.formats.newick;

import info.bioinfweb.commons.log.ApplicationLogger;
import info.bioinfweb.jphyloio.ReadWriteParameterMap;
import info.bioinfweb.jphyloio.dataadapters.DocumentDataAdapter;
import info.bioinfweb.jphyloio.dataadapters.OTUListDataAdapter;
import info.bioinfweb.jphyloio.dataadapters.TreeNetworkDataAdapter;
import info.bioinfweb.jphyloio.dataadapters.TreeNetworkGroupDataAdapter;
import info.bioinfweb.jphyloio.formats.newick.DefaultNewickWriterNodeLabelProcessor;
import info.bioinfweb.jphyloio.formats.newick.NewickConstants;
import info.bioinfweb.jphyloio.formats.newick.NewickStringWriter;
import info.bioinfweb.jphyloio.formats.text.AbstractTextEventWriter;
import info.bioinfweb.jphyloio.formats.text.TextWriterStreamDataProvider;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;

public class NewickEventWriter
extends AbstractTextEventWriter<TextWriterStreamDataProvider<NewickEventWriter>>
implements NewickConstants {
    @Override
    public String getFormatID() {
        return "info.bioinfweb.jphyloio.newick";
    }

    @Override
    protected TextWriterStreamDataProvider<NewickEventWriter> createStreamDataProvider() {
        return new TextWriterStreamDataProvider<NewickEventWriter>(this);
    }

    @Override
    protected void doWriteDocument(DocumentDataAdapter documentDataAdapter, Writer writer, ReadWriteParameterMap readWriteParameterMap) throws IOException {
        super.doWriteDocument(documentDataAdapter, writer, readWriteParameterMap);
        ApplicationLogger applicationLogger = readWriteParameterMap.getLogger();
        int n = 0;
        NewickEventWriter.logIngnoredOTULists(documentDataAdapter, applicationLogger, readWriteParameterMap, "Newick/NHX", "tree nodes");
        if (documentDataAdapter.getMatrixIterator(readWriteParameterMap).hasNext()) {
            applicationLogger.addWarning("The specified matrix (matrices) will not be written, since the Newick/NHX format does not support such data.");
        }
        Iterator<TreeNetworkGroupDataAdapter> iterator = documentDataAdapter.getTreeNetworkGroupIterator(readWriteParameterMap);
        while (iterator.hasNext()) {
            TreeNetworkGroupDataAdapter treeNetworkGroupDataAdapter = iterator.next();
            OTUListDataAdapter oTUListDataAdapter = NewickEventWriter.getReferencedOTUList(documentDataAdapter, treeNetworkGroupDataAdapter, readWriteParameterMap);
            Iterator<TreeNetworkDataAdapter> iterator2 = treeNetworkGroupDataAdapter.getTreeNetworkIterator(readWriteParameterMap);
            while (iterator2.hasNext()) {
                ++n;
                TreeNetworkDataAdapter treeNetworkDataAdapter = iterator2.next();
                new NewickStringWriter((TextWriterStreamDataProvider)this.getStreamDataProvider(), treeNetworkDataAdapter, new DefaultNewickWriterNodeLabelProcessor(oTUListDataAdapter, readWriteParameterMap), readWriteParameterMap).write();
            }
        }
        if (n == 0) {
            applicationLogger.addWarning("An empty document was written, since no tree definitions were offered by the specified document adapter.");
        }
    }
}

