/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.formats.newick;

import info.bioinfweb.jphyloio.ReadWriteConstants;
import info.bioinfweb.jphyloio.formats.newick.NewickConstants;
import info.bioinfweb.jphyloio.formats.phyloxml.PhyloXMLConstants;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;

public class NHXUtils
implements ReadWriteConstants,
NewickConstants,
PhyloXMLConstants {
    private static final int NHX_KEY_COUNT = 6;
    private static NHXUtils firstInstance = null;
    private Map<String, QName> predicateByKeyMap;
    private Map<QName, String> keyByPredicateMap;

    private NHXUtils() {
        this.createMaps();
    }

    private void createMaps() {
        this.predicateByKeyMap = new HashMap<String, QName>(6);
        this.predicateByKeyMap.put("GN", PREDICATE_SEQUENCE_NAME);
        this.predicateByKeyMap.put("AC", PREDICATE_SEQUENCE_ACCESSION_VALUE);
        this.predicateByKeyMap.put("B", PREDICATE_CONFIDENCE_VALUE);
        this.predicateByKeyMap.put("S", PREDICATE_TAXONOMY_SCIENTIFIC_NAME);
        this.predicateByKeyMap.put("T", PREDICATE_TAXONOMY_ID_VALUE);
        this.keyByPredicateMap = new HashMap<QName, String>(6);
        for (String string : this.predicateByKeyMap.keySet()) {
            this.keyByPredicateMap.put(this.predicateByKeyMap.get(string), string);
        }
    }

    public static NHXUtils getInstance() {
        if (firstInstance == null) {
            firstInstance = new NHXUtils();
        }
        return firstInstance;
    }

    public QName predicateByKey(String string) {
        QName qName = this.predicateByKeyMap.get(string);
        if (qName == null) {
            qName = PREDICATE_HAS_LITERAL_METADATA;
        }
        return qName;
    }

    public String keyByPredicate(QName qName) {
        return this.keyByPredicateMap.get(qName);
    }
}

