/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.formats.mega;

import info.bioinfweb.commons.bio.CharacterStateSetType;
import info.bioinfweb.commons.bio.CharacterSymbolMeaning;
import info.bioinfweb.commons.io.StreamLocationProvider;
import info.bioinfweb.commons.text.StringUtils;
import info.bioinfweb.jphyloio.ReadWriteConstants;
import info.bioinfweb.jphyloio.ReadWriteParameterMap;
import info.bioinfweb.jphyloio.events.CharacterSetIntervalEvent;
import info.bioinfweb.jphyloio.events.ConcreteJPhyloIOEvent;
import info.bioinfweb.jphyloio.events.JPhyloIOEvent;
import info.bioinfweb.jphyloio.events.LabeledIDEvent;
import info.bioinfweb.jphyloio.events.LinkedLabeledIDEvent;
import info.bioinfweb.jphyloio.events.PartEndEvent;
import info.bioinfweb.jphyloio.events.SequenceTokensEvent;
import info.bioinfweb.jphyloio.events.SingleTokenDefinitionEvent;
import info.bioinfweb.jphyloio.events.TokenSetDefinitionEvent;
import info.bioinfweb.jphyloio.events.meta.LiteralContentSequenceType;
import info.bioinfweb.jphyloio.events.meta.LiteralMetadataContentEvent;
import info.bioinfweb.jphyloio.events.meta.LiteralMetadataEvent;
import info.bioinfweb.jphyloio.events.meta.URIOrStringIdentifier;
import info.bioinfweb.jphyloio.events.type.EventContentType;
import info.bioinfweb.jphyloio.events.type.EventTopologyType;
import info.bioinfweb.jphyloio.exception.JPhyloIOReaderException;
import info.bioinfweb.jphyloio.formats.mega.MEGAConstants;
import info.bioinfweb.jphyloio.formats.text.AbstractTextEventReader;
import info.bioinfweb.jphyloio.formats.text.KeyValueInformation;
import info.bioinfweb.jphyloio.formats.text.TextReaderStreamDataProvider;
import info.bioinfweb.jphyloio.utils.IDToNameManager;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;

public class MEGAEventReader
extends AbstractTextEventReader<TextReaderStreamDataProvider<MEGAEventReader>>
implements MEGAConstants,
ReadWriteConstants {
    private static final Pattern READ_COMMAND_PATTERN = Pattern.compile(".+(\\[|\\;)", 32);
    private static final Pattern SEQUENCE_NAME_PATTERN = Pattern.compile(".+\\s+");
    private static final String GENE_DONAIN_COMMAND_PATTERN_SUFFIX = "\\s*\\=\\s*(\\w+).*";
    private static final Pattern GENE_COMMAND_PATTERN = Pattern.compile(".*GENE\\s*\\=\\s*(\\w+).*", 2);
    private static final Pattern DOMAIN_COMMAND_PATTERN = Pattern.compile(".*DOMAIN\\s*\\=\\s*(\\w+).*", 2);
    private boolean isInterleaved = false;
    private String currentSequenceName = null;
    private String firstSequenceName = null;
    private long charactersRead = 0L;
    private long currentLabelPos = 0L;
    private String currentGeneOrDomainName = null;
    private long currentGeneOrDomainStart = -1L;
    private IDToNameManager sequenceIDToNameManager = new IDToNameManager("seq");
    private TokenSetDefinitionEvent tokenSetRootEvent = null;
    private List<SingleTokenDefinitionEvent> singleTokenDefinitions = new ArrayList<SingleTokenDefinitionEvent>(2);

    public MEGAEventReader(BufferedReader bufferedReader, ReadWriteParameterMap readWriteParameterMap) throws IOException {
        super(bufferedReader, readWriteParameterMap, readWriteParameterMap.getMatchToken());
    }

    public MEGAEventReader(File file, ReadWriteParameterMap readWriteParameterMap) throws IOException {
        super(file, readWriteParameterMap, readWriteParameterMap.getMatchToken());
    }

    public MEGAEventReader(InputStream inputStream, ReadWriteParameterMap readWriteParameterMap) throws IOException {
        super(inputStream, readWriteParameterMap, readWriteParameterMap.getMatchToken());
    }

    public MEGAEventReader(Reader reader, ReadWriteParameterMap readWriteParameterMap) throws IOException {
        super(reader, readWriteParameterMap, readWriteParameterMap.getMatchToken());
    }

    @Override
    public String getFormatID() {
        return "info.bioinfweb.jphyloio.mega";
    }

    private void checkStart() throws IOException {
        if (!"#MEGA".equals(this.getReader().readString("#MEGA".length()).toUpperCase())) {
            throw new JPhyloIOReaderException("All MEGA files must start with \"#MEGA\".", 0L, 0L, 0L);
        }
    }

    private void processFormatSubcommand(String string, String string2) {
        if (string.toUpperCase().equals("IDENTICAL")) {
            this.getSequenceTokensEventManager().setMatchToken(string2);
        }
    }

    private CharacterStateSetType getTokenSetType(String string) {
        if (string.equals("NUCLEOTIDE")) {
            return CharacterStateSetType.NUCLEOTIDE;
        }
        if (string.equals("DNA")) {
            return CharacterStateSetType.DNA;
        }
        if (string.equals("RNA")) {
            return CharacterStateSetType.RNA;
        }
        if (string.equals("PROTEIN")) {
            return CharacterStateSetType.AMINO_ACID;
        }
        return CharacterStateSetType.UNKNOWN;
    }

    private void readFormatCommand() throws IOException {
        try {
            this.getReader().skip((long)"FORMAT".length());
            this.consumeWhiteSpaceAndComments('!', ']');
            while (this.getReader().peekChar() != ';') {
                Long l;
                KeyValueInformation keyValueInformation = this.readKeyValueInformation(';', '[', ']', '=');
                this.processFormatSubcommand(keyValueInformation.getOriginalKey(), keyValueInformation.getValue());
                String object = keyValueInformation.getOriginalKey().toUpperCase();
                try {
                    l = Long.parseLong(keyValueInformation.getValue());
                }
                catch (NumberFormatException numberFormatException) {
                    l = null;
                }
                if ("NSITES".equals(object)) {
                    if (l == null) {
                        throw new JPhyloIOReaderException("The column count (NSITES) found in the document (\"" + keyValueInformation.getValue() + "\") is not a valid integer.", (StreamLocationProvider)this.getReader());
                    }
                    this.getCurrentEventCollection().add(new LiteralMetadataEvent("meta" + ((TextReaderStreamDataProvider)this.getStreamDataProvider()).getIDManager().createNewID(), keyValueInformation.getOriginalKey(), new URIOrStringIdentifier(keyValueInformation.getOriginalKey(), PREDICATE_CHARACTER_COUNT), LiteralContentSequenceType.SIMPLE));
                    this.getCurrentEventCollection().add(new LiteralMetadataContentEvent(l, keyValueInformation.getValue()));
                    this.getCurrentEventCollection().add(ConcreteJPhyloIOEvent.createEndEvent(EventContentType.LITERAL_META));
                    continue;
                }
                if ("NTAXA".equals(object)) {
                    if (l == null) {
                        throw new JPhyloIOReaderException("The sequence count (NTAX) found in the document (\"" + keyValueInformation.getValue() + "\") is not a valid integer.", (StreamLocationProvider)this.getReader());
                    }
                    this.getCurrentEventCollection().add(new LiteralMetadataEvent("meta" + ((TextReaderStreamDataProvider)this.getStreamDataProvider()).getIDManager().createNewID(), keyValueInformation.getOriginalKey(), new URIOrStringIdentifier(keyValueInformation.getOriginalKey(), PREDICATE_SEQUENCE_COUNT), LiteralContentSequenceType.SIMPLE));
                    this.getCurrentEventCollection().add(new LiteralMetadataContentEvent(l, keyValueInformation.getValue()));
                    this.getCurrentEventCollection().add(ConcreteJPhyloIOEvent.createEndEvent(EventContentType.LITERAL_META));
                    continue;
                }
                if ("DATATYPE".equals(object)) {
                    if (this.tokenSetRootEvent == null) {
                        this.tokenSetRootEvent = new TokenSetDefinitionEvent(this.getTokenSetType(keyValueInformation.getValue().toUpperCase()), "tokenSet" + ((TextReaderStreamDataProvider)this.getStreamDataProvider()).getIDManager().createNewID(), null);
                        continue;
                    }
                    throw new JPhyloIOReaderException("Duplicate token set definition in MEGA FORMAT command.", (StreamLocationProvider)((TextReaderStreamDataProvider)this.getStreamDataProvider()).getDataReader());
                }
                if ("MISSING".equals(object)) {
                    this.singleTokenDefinitions.add(new SingleTokenDefinitionEvent("tokenDefinition" + ((TextReaderStreamDataProvider)this.getStreamDataProvider()).getIDManager().createNewID(), null, keyValueInformation.getValue(), CharacterSymbolMeaning.MISSING, null));
                    continue;
                }
                if ("INDEL".equals(object)) {
                    this.singleTokenDefinitions.add(new SingleTokenDefinitionEvent("tokenDefinition" + ((TextReaderStreamDataProvider)this.getStreamDataProvider()).getIDManager().createNewID(), null, keyValueInformation.getValue(), CharacterSymbolMeaning.GAP, null));
                    continue;
                }
                if ("DATAFORMAT".equals(object)) {
                    this.isInterleaved = "INTERLEAVED".equals(keyValueInformation.getValue().toUpperCase());
                }
                this.getCurrentEventCollection().add(new LiteralMetadataEvent("meta" + ((TextReaderStreamDataProvider)this.getStreamDataProvider()).getIDManager().createNewID(), keyValueInformation.getOriginalKey(), new URIOrStringIdentifier(keyValueInformation.getOriginalKey(), new QName("http://bioinfweb.info/xmlns/JPhyloIO/Formats/MEGA/Predicates/", "FORMAT." + keyValueInformation.getOriginalKey().toUpperCase())), LiteralContentSequenceType.SIMPLE));
                this.getCurrentEventCollection().add(new LiteralMetadataContentEvent(keyValueInformation.getValue(), false));
                this.getCurrentEventCollection().add(ConcreteJPhyloIOEvent.createEndEvent(EventContentType.LITERAL_META));
            }
            if (this.tokenSetRootEvent != null) {
                this.getCurrentEventCollection().add(this.tokenSetRootEvent);
                for (SingleTokenDefinitionEvent singleTokenDefinitionEvent : this.singleTokenDefinitions) {
                    this.getCurrentEventCollection().add(singleTokenDefinitionEvent);
                    this.getCurrentEventCollection().add(ConcreteJPhyloIOEvent.createEndEvent(EventContentType.SINGLE_TOKEN_DEFINITION));
                }
                this.getCurrentEventCollection().add(ConcreteJPhyloIOEvent.createEndEvent(EventContentType.TOKEN_SET_DEFINITION));
            }
            this.getReader().skip(1L);
        }
        catch (EOFException eOFException) {
            throw new JPhyloIOReaderException("Unexpected end of file in FORMAT command.", (StreamLocationProvider)this.getReader(), (Throwable)eOFException);
        }
    }

    private URIOrStringIdentifier createCommandPredicate(String string) {
        return new URIOrStringIdentifier(string, new QName("http://bioinfweb.info/xmlns/JPhyloIO/Formats/MEGA/Predicates/", string.toUpperCase()));
    }

    private void addMetaEventsFromCommand(String string) throws IOException {
        int n = StringUtils.indexOfWhiteSpace((CharSequence)string);
        if (n < 1) {
            this.getCurrentEventCollection().add(new LiteralMetadataEvent("meta" + ((TextReaderStreamDataProvider)this.getStreamDataProvider()).getIDManager().createNewID(), null, new URIOrStringIdentifier(null, PREDICATE_HAS_LITERAL_METADATA), LiteralContentSequenceType.SIMPLE));
        } else {
            String string2 = string.substring(0, n);
            string = string.substring(n).trim();
            this.getCurrentEventCollection().add(new LiteralMetadataEvent("meta" + ((TextReaderStreamDataProvider)this.getStreamDataProvider()).getIDManager().createNewID(), string2, this.createCommandPredicate(string2), LiteralContentSequenceType.SIMPLE));
        }
        this.getCurrentEventCollection().add(new LiteralMetadataContentEvent(string, false));
        this.getCurrentEventCollection().add(ConcreteJPhyloIOEvent.createEndEvent(EventContentType.LITERAL_META));
    }

    private void createCharacterSetEventsFromLabel() throws IOException {
        this.getReader().skip((long)"LABEL".length());
        long l = this.currentLabelPos;
        long l2 = -1L;
        char c = '_';
        char c2 = this.getReader().readChar();
        this.getCurrentEventCollection().add(new LabeledIDEvent(EventContentType.CHARACTER_SET, "MEGALabelCharacterSet", Character.toString('_')));
        while (c2 != ';') {
            if (!Character.isWhitespace(c2)) {
                if (c2 == '[') {
                    this.readComment('[', ']');
                } else {
                    if (c == '_' && c2 != '_' || c2 != c) {
                        if (c2 != c && c != '_') {
                            this.getCurrentEventCollection().add(new CharacterSetIntervalEvent(l2, l));
                        }
                        l2 = l;
                        c = c2;
                    }
                    ++l;
                }
            }
            c2 = this.getReader().readChar();
        }
        if (c != '_') {
            this.getCurrentEventCollection().add(new CharacterSetIntervalEvent(l2, l));
        }
        this.currentLabelPos = l;
        this.getCurrentEventCollection().add(new PartEndEvent(EventContentType.CHARACTER_SET, false));
    }

    private static String extractGeneOrDomainID(String string) {
        Matcher matcher = GENE_COMMAND_PATTERN.matcher(string);
        if (matcher.matches()) {
            return "GENE." + matcher.group(1);
        }
        matcher = DOMAIN_COMMAND_PATTERN.matcher(string);
        if (matcher.matches()) {
            return "DOMAIN." + matcher.group(1);
        }
        return null;
    }

    private void createGeneOrDomainCharSetEvents() {
        this.getCurrentEventCollection().add(new LabeledIDEvent(EventContentType.CHARACTER_SET, MEGAEventReader.extractGeneOrDomainID(this.currentGeneOrDomainName), this.currentGeneOrDomainName));
        this.getCurrentEventCollection().add(new CharacterSetIntervalEvent(this.currentGeneOrDomainStart, this.charactersRead));
        this.getCurrentEventCollection().add(new PartEndEvent(EventContentType.CHARACTER_SET, false));
    }

    private void readCommand() throws IOException {
        int n = this.getReader().peek();
        if (n != -1 && (char)n == '!') {
            this.endSequence();
            this.getReader().read();
            this.consumeWhiteSpaceAndComments('[', ']');
            if (this.getReader().peekString("LABEL".length()).toUpperCase().equals("LABEL")) {
                this.createCharacterSetEventsFromLabel();
            } else if (this.getReader().peekString("FORMAT".length()).toUpperCase().equals("FORMAT")) {
                this.readFormatCommand();
            } else {
                CharSequence charSequence;
                StringBuilder stringBuilder = new StringBuilder();
                do {
                    if ((charSequence = this.getReader().readRegExp(READ_COMMAND_PATTERN, false).getSequence()).charAt(charSequence.length() - 1) == '[') {
                        this.readComment('[', ']');
                    }
                    stringBuilder.append(charSequence.subSequence(0, charSequence.length() - 1));
                } while (charSequence.charAt(charSequence.length() - 1) != ';');
                String string = stringBuilder.toString().trim();
                String string2 = string.toUpperCase();
                if (!string2.startsWith("TITLE") && !string2.startsWith("DESCRIPTION") && (DOMAIN_COMMAND_PATTERN.matcher(string).matches() || GENE_COMMAND_PATTERN.matcher(string).matches())) {
                    if (this.currentGeneOrDomainName != null) {
                        this.createGeneOrDomainCharSetEvents();
                    }
                    this.currentGeneOrDomainName = string;
                    this.currentGeneOrDomainStart = this.charactersRead;
                } else {
                    this.addMetaEventsFromCommand(string);
                }
            }
        }
    }

    private void readSequenceName() throws IOException {
        this.getReader().read();
        this.currentSequenceName = this.getReader().readRegExp(SEQUENCE_NAME_PATTERN, false).getSequence().toString().trim();
        if (this.firstSequenceName == null) {
            this.firstSequenceName = this.currentSequenceName;
        } else if (this.firstSequenceName.equals(this.currentSequenceName)) {
            this.currentLabelPos = Math.max(this.currentLabelPos, this.charactersRead);
        }
        this.getCurrentEventCollection().add(new LinkedLabeledIDEvent(EventContentType.SEQUENCE, this.sequenceIDToNameManager.getID(this.currentSequenceName), this.currentSequenceName, null));
    }

    private void countCharacters(JPhyloIOEvent jPhyloIOEvent) {
        if (jPhyloIOEvent.getType().getContentType().equals((Object)EventContentType.SEQUENCE_TOKENS)) {
            SequenceTokensEvent sequenceTokensEvent = jPhyloIOEvent.asSequenceTokensEvent();
            if (this.currentSequenceName.equals(this.firstSequenceName)) {
                this.charactersRead += (long)sequenceTokensEvent.getTokens().size();
            }
        }
    }

    private void endSequence() {
        if (this.currentSequenceName != null) {
            this.getCurrentEventCollection().add(new PartEndEvent(EventContentType.SEQUENCE, !this.isInterleaved));
            this.currentSequenceName = null;
        }
    }

    @Override
    protected void readNextEvent() throws IOException {
        if (this.isBeforeFirstAccess()) {
            this.checkStart();
            this.consumeWhiteSpaceAndComments('[', ']');
            this.getCurrentEventCollection().add(new ConcreteJPhyloIOEvent(EventContentType.DOCUMENT, EventTopologyType.START));
        } else {
            switch (this.getLastNonCommentEvent().getType().getContentType()) {
                case DOCUMENT: {
                    if (!this.getLastNonCommentEvent().getType().getTopologyType().equals((Object)EventTopologyType.START)) break;
                    this.getCurrentEventCollection().add(new LinkedLabeledIDEvent(EventContentType.ALIGNMENT, "matrix" + this.getIDManager().createNewID(), null, null));
                    break;
                }
                case ALIGNMENT: {
                    if (this.getLastNonCommentEvent().getType().getTopologyType().equals((Object)EventTopologyType.END)) {
                        this.getCurrentEventCollection().add(new ConcreteJPhyloIOEvent(EventContentType.DOCUMENT, EventTopologyType.END));
                        break;
                    }
                }
                case TOKEN_SET_DEFINITION: 
                case SINGLE_TOKEN_DEFINITION: 
                case SEQUENCE: 
                case SEQUENCE_TOKENS: 
                case CHARACTER_SET: 
                case LITERAL_META: 
                case COMMENT: {
                    JPhyloIOEvent jPhyloIOEvent;
                    this.readCommand();
                    this.consumeWhiteSpaceAndComments('[', ']');
                    if (!this.getCurrentEventCollection().isEmpty()) break;
                    int n = this.getReader().peek();
                    if (n == -1) {
                        this.endSequence();
                        if (this.currentGeneOrDomainName != null) {
                            this.createGeneOrDomainCharSetEvents();
                            this.currentGeneOrDomainName = null;
                            break;
                        }
                        this.getCurrentEventCollection().add(new ConcreteJPhyloIOEvent(EventContentType.ALIGNMENT, EventTopologyType.END));
                        break;
                    }
                    if (n == 35) {
                        this.endSequence();
                        this.readSequenceName();
                        this.consumeWhiteSpaceAndComments('[', ']');
                    }
                    if ((jPhyloIOEvent = this.readCharacters(this.currentSequenceName, '[', ']')) != null) {
                        this.consumeWhiteSpaceAndComments('[', ']');
                        this.countCharacters(jPhyloIOEvent);
                        break;
                    }
                    this.readNextEvent();
                    break;
                }
                default: {
                    throw new InternalError("Unexpected event type " + this.getLastNonCommentEvent().getType());
                }
            }
        }
    }
}

