/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.formats.fasta;

import info.bioinfweb.commons.io.PeekReader;
import info.bioinfweb.commons.io.StreamLocationProvider;
import info.bioinfweb.jphyloio.ReadWriteParameterMap;
import info.bioinfweb.jphyloio.events.CommentEvent;
import info.bioinfweb.jphyloio.events.ConcreteJPhyloIOEvent;
import info.bioinfweb.jphyloio.events.JPhyloIOEvent;
import info.bioinfweb.jphyloio.events.LinkedLabeledIDEvent;
import info.bioinfweb.jphyloio.events.PartEndEvent;
import info.bioinfweb.jphyloio.events.type.EventContentType;
import info.bioinfweb.jphyloio.events.type.EventTopologyType;
import info.bioinfweb.jphyloio.exception.JPhyloIOReaderException;
import info.bioinfweb.jphyloio.formats.fasta.FASTAConstants;
import info.bioinfweb.jphyloio.formats.text.AbstractTextEventReader;
import info.bioinfweb.jphyloio.formats.text.TextReaderStreamDataProvider;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;

public class FASTAEventReader
extends AbstractTextEventReader<TextReaderStreamDataProvider<FASTAEventReader>>
implements FASTAConstants {
    private String currentSequenceName = null;

    public FASTAEventReader(BufferedReader bufferedReader, ReadWriteParameterMap readWriteParameterMap) throws IOException {
        super(bufferedReader, readWriteParameterMap, readWriteParameterMap.getMatchToken());
    }

    public FASTAEventReader(File file, ReadWriteParameterMap readWriteParameterMap) throws IOException {
        super(file, readWriteParameterMap, readWriteParameterMap.getMatchToken());
    }

    public FASTAEventReader(InputStream inputStream, ReadWriteParameterMap readWriteParameterMap) throws IOException {
        super(inputStream, readWriteParameterMap, readWriteParameterMap.getMatchToken());
    }

    public FASTAEventReader(Reader reader, ReadWriteParameterMap readWriteParameterMap) throws IOException {
        super(reader, readWriteParameterMap, readWriteParameterMap.getMatchToken());
    }

    @Override
    public String getFormatID() {
        return "info.bioinfweb.jphyloio.fasta";
    }

    private JPhyloIOEvent readSequenceStart(String string) throws IOException {
        try {
            if (this.getReader().readChar() == '>') {
                this.currentSequenceName = this.getReader().readLine().getSequence().toString();
                this.getCurrentEventCollection().add(new LinkedLabeledIDEvent(EventContentType.SEQUENCE, "seq" + this.getIDManager().createNewID(), this.currentSequenceName, null));
                int n = this.getParameters().getMaxCommentLength();
                while (this.getReader().peekChar() == ';') {
                    PeekReader.ReadResult readResult;
                    this.getReader().read();
                    do {
                        readResult = this.getReader().readLine(n);
                        this.getCurrentEventCollection().add(new CommentEvent(readResult.getSequence().toString(), !readResult.isCompletelyRead()));
                    } while (!readResult.isCompletelyRead());
                }
                return null;
            }
            throw new JPhyloIOReaderException(string, (StreamLocationProvider)this.getReader());
        }
        catch (EOFException eOFException) {
            return new ConcreteJPhyloIOEvent(EventContentType.ALIGNMENT, EventTopologyType.END);
        }
    }

    private boolean consumeTokenIndex() throws IOException {
        try {
            char c = this.getReader().peekChar();
            while (Character.isWhitespace(c) || Character.isDigit(c)) {
                this.getReader().skip(1L);
                c = this.getReader().peekChar();
            }
            return true;
        }
        catch (EOFException eOFException) {
            return false;
        }
    }

    @Override
    protected void readNextEvent() throws IOException {
        if (this.isBeforeFirstAccess()) {
            this.getCurrentEventCollection().add(new ConcreteJPhyloIOEvent(EventContentType.DOCUMENT, EventTopologyType.START));
        } else {
            switch (this.getPreviousEvent().getType().getContentType()) {
                case DOCUMENT: {
                    if (this.getPreviousEvent().getType().getTopologyType().equals((Object)EventTopologyType.START)) {
                        this.getCurrentEventCollection().add(new LinkedLabeledIDEvent(EventContentType.ALIGNMENT, "matrix" + this.getIDManager().createNewID(), null, null));
                        break;
                    }
                    return;
                }
                case ALIGNMENT: {
                    JPhyloIOEvent jPhyloIOEvent;
                    if (this.getPreviousEvent().getType().getTopologyType().equals((Object)EventTopologyType.START)) {
                        jPhyloIOEvent = this.readSequenceStart("FASTA file does not start with a \">\".");
                        if (jPhyloIOEvent != null) {
                            this.getCurrentEventCollection().add(jPhyloIOEvent);
                            break;
                        }
                        this.lineConsumed = true;
                    } else {
                        this.getCurrentEventCollection().add(new ConcreteJPhyloIOEvent(EventContentType.DOCUMENT, EventTopologyType.END));
                        break;
                    }
                }
                case SEQUENCE: 
                case SEQUENCE_TOKENS: 
                case COMMENT: {
                    JPhyloIOEvent jPhyloIOEvent;
                    int n = this.getReader().peek();
                    if (n == -1 || this.lineConsumed && n == 62) {
                        this.getCurrentEventCollection().add(new PartEndEvent(EventContentType.SEQUENCE, true));
                        jPhyloIOEvent = this.readSequenceStart("Inconsistent stream. (The cause might be code outside this class reading from the same stream.)");
                        if (jPhyloIOEvent != null) {
                            this.getCurrentEventCollection().add(jPhyloIOEvent);
                        }
                        if (!this.getUpcomingEvents().isEmpty()) break;
                    }
                    if (this.lineConsumed && !this.consumeTokenIndex()) {
                        this.getCurrentEventCollection().add(new PartEndEvent(EventContentType.SEQUENCE, true));
                        this.getCurrentEventCollection().add(new ConcreteJPhyloIOEvent(EventContentType.ALIGNMENT, EventTopologyType.END));
                        break;
                    }
                    PeekReader.ReadResult readResult = this.getReader().readLine(this.getParameters().getMaxTokensToRead());
                    ArrayList<String> arrayList = new ArrayList<String>(readResult.getSequence().length());
                    for (int i = 0; i < readResult.getSequence().length(); ++i) {
                        arrayList.add(Character.toString(readResult.getSequence().charAt(i)));
                    }
                    this.lineConsumed = readResult.isCompletelyRead();
                    this.getCurrentEventCollection().add(this.getSequenceTokensEventManager().createEvent(this.currentSequenceName, arrayList));
                    break;
                }
                default: {
                    throw new InternalError("Impossible case");
                }
            }
        }
    }
}

