/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.factory;

import info.bioinfweb.commons.io.ClosingNotAllowedException;
import info.bioinfweb.commons.io.LimitedInputStream;
import info.bioinfweb.commons.io.LimitedReader;
import info.bioinfweb.jphyloio.JPhyloIOEventReader;
import info.bioinfweb.jphyloio.JPhyloIOEventWriter;
import info.bioinfweb.jphyloio.ReadWriteParameterMap;
import info.bioinfweb.jphyloio.factory.SingleReaderWriterFactory;
import info.bioinfweb.jphyloio.formatinfo.JPhyloIOFormatInfo;
import info.bioinfweb.jphyloio.formats.JPhyloIOFormatIDs;
import info.bioinfweb.jphyloio.formats.fasta.FASTAFactory;
import info.bioinfweb.jphyloio.formats.mega.MEGAFactory;
import info.bioinfweb.jphyloio.formats.newick.NewickFactory;
import info.bioinfweb.jphyloio.formats.nexml.NeXMLFactory;
import info.bioinfweb.jphyloio.formats.nexus.NexusFactory;
import info.bioinfweb.jphyloio.formats.pde.PDEFactory;
import info.bioinfweb.jphyloio.formats.phylip.PhylipFactory;
import info.bioinfweb.jphyloio.formats.phylip.SequentialPhylipFactory;
import info.bioinfweb.jphyloio.formats.phyloxml.PhyloXMLFactory;
import info.bioinfweb.jphyloio.formats.xtg.XTGFactory;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipException;
import org.apache.commons.collections4.map.ListOrderedMap;

public class JPhyloIOReaderWriterFactory
implements JPhyloIOFormatIDs {
    public static final int DEFAULT_READ_AHEAD_LIMIT = 8192;
    private final ReadWriteLock readAheadLimitLock = new ReentrantReadWriteLock();
    private ListOrderedMap<String, SingleReaderWriterFactory> formatMap = new ListOrderedMap();
    private Set<String> formatIDsSet;
    private int readAheadLimit = 8192;

    public JPhyloIOReaderWriterFactory() {
        this.fillMap();
        this.formatIDsSet = Collections.unmodifiableSet(this.formatMap.keySet());
    }

    public SingleReaderWriterFactory addFactory(SingleReaderWriterFactory singleReaderWriterFactory) {
        return (SingleReaderWriterFactory)this.formatMap.put((Object)singleReaderWriterFactory.getFormatInfo().getFormatID(), (Object)singleReaderWriterFactory);
    }

    public void removeAllFactories() {
        this.formatMap.clear();
    }

    private void fillMap() {
        this.addFactory(new NeXMLFactory());
        this.addFactory(new NexusFactory());
        this.addFactory(new PhyloXMLFactory());
        this.addFactory(new FASTAFactory());
        this.addFactory(new PhylipFactory());
        this.addFactory(new MEGAFactory());
        this.addFactory(new XTGFactory());
        this.addFactory(new PDEFactory());
        this.addFactory(new NewickFactory());
        this.addFactory(new SequentialPhylipFactory());
    }

    public int getReadAheadLimit() {
        this.readAheadLimitLock.readLock().lock();
        try {
            int n = this.readAheadLimit;
            return n;
        }
        finally {
            this.readAheadLimitLock.readLock().unlock();
        }
    }

    public void setReadAheadLimit(int n) {
        this.readAheadLimitLock.writeLock().lock();
        try {
            this.readAheadLimit = n;
        }
        finally {
            this.readAheadLimitLock.writeLock().unlock();
        }
    }

    public Set<String> getFormatIDsSet() {
        return this.formatIDsSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String guessFormat(File file, ReadWriteParameterMap readWriteParameterMap) throws Exception {
        String string;
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            string = this.guessFormat(new FileReader(file), readWriteParameterMap);
        }
        return string;
    }

    public String guessFormat(File file) throws Exception {
        return this.guessFormat(file, new ReadWriteParameterMap());
    }

    public String guessFormat(Reader reader, ReadWriteParameterMap readWriteParameterMap) throws Exception {
        LimitedReader limitedReader = new LimitedReader((Reader)new BufferedReader(reader, this.getReadAheadLimit()), (long)this.getReadAheadLimit());
        limitedReader.mark(this.getReadAheadLimit());
        limitedReader.setAllowClose(false);
        for (SingleReaderWriterFactory singleReaderWriterFactory : this.formatMap.values()) {
            boolean bl;
            try {
                bl = singleReaderWriterFactory.checkFormat((Reader)limitedReader, readWriteParameterMap);
            }
            catch (ClosingNotAllowedException closingNotAllowedException) {
                bl = false;
            }
            limitedReader.reset();
            if (!bl) continue;
            return singleReaderWriterFactory.getFormatInfo().getFormatID();
        }
        return null;
    }

    public String guessFormat(Reader reader) throws Exception {
        return this.guessFormat(reader, new ReadWriteParameterMap());
    }

    public String guessFormat(InputStream inputStream, ReadWriteParameterMap readWriteParameterMap) throws Exception {
        return this.guessFormatFromLimitedStream((InputStream)new LimitedInputStream((InputStream)new BufferedInputStream(inputStream, this.getReadAheadLimit()), (long)this.getReadAheadLimit()), readWriteParameterMap);
    }

    private String guessFormatFromLimitedStream(InputStream inputStream, ReadWriteParameterMap readWriteParameterMap) throws Exception {
        inputStream.mark(this.getReadAheadLimit());
        for (SingleReaderWriterFactory singleReaderWriterFactory : this.formatMap.values()) {
            boolean bl = singleReaderWriterFactory.checkFormat(inputStream, readWriteParameterMap);
            inputStream.reset();
            if (!bl) continue;
            return singleReaderWriterFactory.getFormatInfo().getFormatID();
        }
        return null;
    }

    public String guessFormat(InputStream inputStream) throws Exception {
        return this.guessFormat(inputStream, new ReadWriteParameterMap());
    }

    public JPhyloIOFormatInfo getFormatInfo(String string) {
        SingleReaderWriterFactory singleReaderWriterFactory = (SingleReaderWriterFactory)this.formatMap.get((Object)string);
        if (singleReaderWriterFactory == null) {
            return null;
        }
        return singleReaderWriterFactory.getFormatInfo();
    }

    public JPhyloIOEventReader guessReader(InputStream inputStream, ReadWriteParameterMap readWriteParameterMap) throws Exception {
        FilterInputStream filterInputStream = new BufferedInputStream(inputStream, this.getReadAheadLimit());
        Object object = new LimitedInputStream((InputStream)filterInputStream, (long)this.getReadAheadLimit());
        ((InputStream)object).mark(this.getReadAheadLimit());
        boolean bl = true;
        try {
            object = new BufferedInputStream(new GZIPInputStream((InputStream)object), this.getReadAheadLimit());
            ((InputStream)object).mark(this.getReadAheadLimit());
        }
        catch (ZipException zipException) {
            bl = false;
            ((InputStream)object).reset();
        }
        String string = this.guessFormatFromLimitedStream((InputStream)object, readWriteParameterMap);
        if (string == null) {
            return null;
        }
        if (bl) {
            ((InputStream)filterInputStream).reset();
            filterInputStream = new GZIPInputStream(filterInputStream);
        }
        return this.getReader(string, filterInputStream, readWriteParameterMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JPhyloIOEventReader guessReader(File file, ReadWriteParameterMap readWriteParameterMap) throws Exception {
        JPhyloIOEventReader jPhyloIOEventReader = null;
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            jPhyloIOEventReader = this.guessReader(fileInputStream, readWriteParameterMap);
        }
        finally {
            if (jPhyloIOEventReader == null) {
                fileInputStream.close();
            }
        }
        return jPhyloIOEventReader;
    }

    public JPhyloIOEventReader getReader(String string, InputStream inputStream, ReadWriteParameterMap readWriteParameterMap) throws Exception {
        SingleReaderWriterFactory singleReaderWriterFactory = (SingleReaderWriterFactory)this.formatMap.get((Object)string);
        if (singleReaderWriterFactory == null) {
            return null;
        }
        return singleReaderWriterFactory.getReader(inputStream, readWriteParameterMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JPhyloIOEventReader getReader(String string, File file, ReadWriteParameterMap readWriteParameterMap) throws Exception {
        JPhyloIOEventReader jPhyloIOEventReader = null;
        FileReader fileReader = new FileReader(file);
        try {
            jPhyloIOEventReader = this.getReader(string, fileReader, readWriteParameterMap);
        }
        finally {
            if (jPhyloIOEventReader == null) {
                fileReader.close();
            }
        }
        return jPhyloIOEventReader;
    }

    public JPhyloIOEventReader getReader(String string, Reader reader, ReadWriteParameterMap readWriteParameterMap) throws Exception {
        SingleReaderWriterFactory singleReaderWriterFactory = (SingleReaderWriterFactory)this.formatMap.get((Object)string);
        if (singleReaderWriterFactory == null) {
            return null;
        }
        return singleReaderWriterFactory.getReader(reader, readWriteParameterMap);
    }

    public JPhyloIOEventWriter getWriter(String string) {
        SingleReaderWriterFactory singleReaderWriterFactory = (SingleReaderWriterFactory)this.formatMap.get((Object)string);
        if (singleReaderWriterFactory == null) {
            return null;
        }
        return singleReaderWriterFactory.getWriter();
    }
}

