/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.events.type;

import info.bioinfweb.jphyloio.events.type.EventContentType;
import info.bioinfweb.jphyloio.events.type.EventTopologyType;

public class EventType
implements Comparable<EventType> {
    private EventContentType contentType;
    private EventTopologyType topologyType;

    public EventType(EventContentType eventContentType, EventTopologyType eventTopologyType) {
        if (eventContentType == null) {
            throw new NullPointerException("The content type must not be null.");
        }
        this.contentType = eventContentType;
        if (eventTopologyType == null) {
            throw new NullPointerException("The topology type must not be null.");
        }
        this.topologyType = eventTopologyType;
    }

    public EventContentType getContentType() {
        return this.contentType;
    }

    public EventTopologyType getTopologyType() {
        return this.topologyType;
    }

    @Override
    public int compareTo(EventType eventType) {
        int n = this.getContentType().compareTo(eventType.getContentType());
        if (n == 0) {
            n = this.getTopologyType().compareTo(eventType.getTopologyType());
        }
        return n;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.contentType == null ? 0 : this.contentType.hashCode());
        n = 31 * n + (this.topologyType == null ? 0 : this.topologyType.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        EventType eventType = (EventType)object;
        if (this.contentType != eventType.contentType) {
            return false;
        }
        return this.topologyType == eventType.topologyType;
    }

    public String toString() {
        return this.getContentType().toString() + "." + this.getTopologyType().toString();
    }
}

