/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.events.meta;

import info.bioinfweb.jphyloio.events.ContinuedEvent;
import info.bioinfweb.jphyloio.events.type.EventContentType;
import javax.xml.stream.events.XMLEvent;

public class LiteralMetadataContentEvent
extends ContinuedEvent {
    private String stringValue;
    private Object objectValue;

    public LiteralMetadataContentEvent(String string, boolean bl) {
        this(string, null, bl);
    }

    public LiteralMetadataContentEvent(Object object, String string) {
        this(string, object, false);
    }

    private LiteralMetadataContentEvent(String string, Object object, boolean bl) {
        super(EventContentType.LITERAL_META_CONTENT, bl);
        if (string == null && object == null) {
            throw new NullPointerException("Either stringValue or objectValue must be specified. If a literal meta event has no content, the content event should be omitted.");
        }
        this.stringValue = string;
        if (object != null && this.isContinuedInNextEvent()) {
            throw new IllegalArgumentException("If a value is separated among several events no object value may be specified.");
        }
        this.objectValue = object;
    }

    public LiteralMetadataContentEvent(XMLEvent xMLEvent, boolean bl) {
        super(EventContentType.LITERAL_META_CONTENT, bl);
        if (!xMLEvent.isCharacters() && bl) {
            throw new IllegalArgumentException("Only character XML events may be continued in the next event. The specified event had the type " + xMLEvent.getEventType() + ".");
        }
        if (xMLEvent.isCharacters()) {
            this.stringValue = xMLEvent.asCharacters().getData();
        }
        this.objectValue = xMLEvent;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public Object getObjectValue() {
        return this.objectValue;
    }

    public boolean hasStringValue() {
        return this.getStringValue() != null;
    }

    public boolean hasObjectValue() {
        return this.getObjectValue() != null;
    }

    public boolean hasXMLEventValue() {
        return this.getObjectValue() instanceof XMLEvent;
    }

    public XMLEvent getXMLEvent() throws ClassCastException {
        return (XMLEvent)this.getObjectValue();
    }

    public String toString() {
        if (this.hasStringValue()) {
            return this.getStringValue();
        }
        if (this.hasObjectValue()) {
            return this.getObjectValue().toString();
        }
        return super.toString();
    }
}

