/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.dataadapters.implementations.store;

import info.bioinfweb.jphyloio.ReadWriteParameterMap;
import info.bioinfweb.jphyloio.dataadapters.JPhyloIOEventReceiver;
import info.bioinfweb.jphyloio.dataadapters.MatrixDataAdapter;
import info.bioinfweb.jphyloio.dataadapters.implementations.store.StoreAnnotatedDataAdapter;
import info.bioinfweb.jphyloio.dataadapters.implementations.store.StoreObjectListDataAdapter;
import info.bioinfweb.jphyloio.events.CharacterDefinitionEvent;
import info.bioinfweb.jphyloio.events.JPhyloIOEvent;
import info.bioinfweb.jphyloio.events.LinkedLabeledIDEvent;
import info.bioinfweb.jphyloio.events.TokenSetDefinitionEvent;
import info.bioinfweb.jphyloio.events.type.EventContentType;
import info.bioinfweb.jphyloio.events.type.EventTopologyType;
import info.bioinfweb.jphyloio.events.type.EventType;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

public class StoreMatrixDataAdapter
extends StoreAnnotatedDataAdapter<LinkedLabeledIDEvent>
implements MatrixDataAdapter {
    private LinkedLabeledIDEvent startEvent;
    private StoreObjectListDataAdapter<LinkedLabeledIDEvent> matrix = new StoreObjectListDataAdapter();
    private StoreObjectListDataAdapter<CharacterDefinitionEvent> characterDefinitions = new StoreObjectListDataAdapter();
    private StoreObjectListDataAdapter<LinkedLabeledIDEvent> sequenceSets = new StoreObjectListDataAdapter();
    private StoreObjectListDataAdapter<TokenSetDefinitionEvent> tokenSets = new StoreObjectListDataAdapter();
    private StoreObjectListDataAdapter<LinkedLabeledIDEvent> characterSets = new StoreObjectListDataAdapter();
    private boolean longTokens;

    public StoreMatrixDataAdapter(LinkedLabeledIDEvent linkedLabeledIDEvent, boolean bl, List<JPhyloIOEvent> list) {
        super(list);
        this.startEvent = linkedLabeledIDEvent;
        this.longTokens = bl;
    }

    @Override
    public LinkedLabeledIDEvent getStartEvent(ReadWriteParameterMap readWriteParameterMap) {
        return this.startEvent;
    }

    @Override
    public long getSequenceCount(ReadWriteParameterMap readWriteParameterMap) {
        return this.matrix.getObjectMap().size();
    }

    @Override
    public long getColumnCount(ReadWriteParameterMap readWriteParameterMap) {
        long l = 0L;
        long l2 = 0L;
        Iterator<String> iterator = this.getSequenceIDIterator(readWriteParameterMap);
        while (iterator.hasNext()) {
            l = l2;
            l2 = this.getSequenceLength(readWriteParameterMap, iterator.next());
            if (l == 0L || l == l2) continue;
            return -1L;
        }
        return l2;
    }

    @Override
    public boolean containsLongTokens(ReadWriteParameterMap readWriteParameterMap) {
        return this.longTokens;
    }

    public StoreObjectListDataAdapter<LinkedLabeledIDEvent> getMatrix() {
        return this.matrix;
    }

    public StoreObjectListDataAdapter<LinkedLabeledIDEvent> getCharacterSets(ReadWriteParameterMap readWriteParameterMap) {
        return this.characterSets;
    }

    public StoreObjectListDataAdapter<TokenSetDefinitionEvent> getTokenSets(ReadWriteParameterMap readWriteParameterMap) {
        return this.tokenSets;
    }

    @Override
    public Iterator<String> getSequenceIDIterator(ReadWriteParameterMap readWriteParameterMap) {
        return this.matrix.getObjectMap().keyList().iterator();
    }

    @Override
    public LinkedLabeledIDEvent getSequenceStartEvent(ReadWriteParameterMap readWriteParameterMap, String string) throws IllegalArgumentException {
        if (this.matrix.getObjectMap().keyList().contains(string)) {
            return (LinkedLabeledIDEvent)this.matrix.getObjectStartEvent(readWriteParameterMap, string);
        }
        throw new IllegalArgumentException("The alignment does not contain a sequence with the ID \"" + string + "\".");
    }

    @Override
    public long getSequenceLength(ReadWriteParameterMap readWriteParameterMap, String string) throws IllegalArgumentException {
        if (this.matrix.getObjectMap().keyList().contains(string)) {
            int n = 0;
            for (JPhyloIOEvent jPhyloIOEvent : this.matrix.getObjectContent(string)) {
                if (jPhyloIOEvent.getType().equals(new EventType(EventContentType.SINGLE_SEQUENCE_TOKEN, EventTopologyType.START))) {
                    ++n;
                    continue;
                }
                if (!jPhyloIOEvent.getType().getContentType().equals((Object)EventContentType.SEQUENCE_TOKENS)) continue;
                n += jPhyloIOEvent.asSequenceTokensEvent().getTokens().size();
            }
            return n;
        }
        throw new IllegalArgumentException("The alignment does not contain a sequence with the ID \"" + string + "\".");
    }

    @Override
    public void writeSequencePartContentData(ReadWriteParameterMap readWriteParameterMap, JPhyloIOEventReceiver jPhyloIOEventReceiver, String string, long l, long l2) throws IOException, IllegalArgumentException {
        if (this.matrix.getObjectMap().keyList().contains(string)) {
            for (JPhyloIOEvent jPhyloIOEvent : this.matrix.getObjectContent(string)) {
                jPhyloIOEventReceiver.add(jPhyloIOEvent);
            }
        } else {
            throw new IllegalArgumentException("The alignment does not contain a sequence with the ID \"" + string + "\".");
        }
    }

    public StoreObjectListDataAdapter<CharacterDefinitionEvent> getCharacterDefinitions(ReadWriteParameterMap readWriteParameterMap) {
        return this.characterDefinitions;
    }

    public StoreObjectListDataAdapter<LinkedLabeledIDEvent> getSequenceSets(ReadWriteParameterMap readWriteParameterMap) {
        return this.sequenceSets;
    }
}

