/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio;

import info.bioinfweb.commons.log.ApplicationLogger;
import info.bioinfweb.jphyloio.AbstractEventWriter;
import info.bioinfweb.jphyloio.ReadWriteParameterMap;
import info.bioinfweb.jphyloio.dataadapters.DocumentDataAdapter;
import info.bioinfweb.jphyloio.dataadapters.MatrixDataAdapter;
import info.bioinfweb.jphyloio.dataadapters.OTUListDataAdapter;
import info.bioinfweb.jphyloio.events.LinkedLabeledIDEvent;
import info.bioinfweb.jphyloio.formats.text.AbstractTextEventWriter;
import info.bioinfweb.jphyloio.formats.text.TextWriterStreamDataProvider;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;

public abstract class AbstractSingleMatrixEventWriter<P extends TextWriterStreamDataProvider<? extends AbstractTextEventWriter<P>>>
extends AbstractTextEventWriter<P> {
    private String formatName;

    public AbstractSingleMatrixEventWriter(String string) {
        this.formatName = string;
    }

    protected abstract void writeSingleMatrix(DocumentDataAdapter var1, MatrixDataAdapter var2, Iterator<String> var3, ReadWriteParameterMap var4) throws IOException;

    protected String editSequenceOrNodeLabel(final LinkedLabeledIDEvent linkedLabeledIDEvent, final ReadWriteParameterMap readWriteParameterMap, OTUListDataAdapter oTUListDataAdapter) {
        return AbstractSingleMatrixEventWriter.createUniqueLinkedOTULabel(readWriteParameterMap, new AbstractEventWriter.UniqueLabelHandler(){

            @Override
            public boolean isUnique(String string) {
                return !readWriteParameterMap.getLabelEditingReporter().isLabelUsed(linkedLabeledIDEvent.getType().getContentType(), string);
            }

            @Override
            public String editLabel(String string) {
                return AbstractSingleMatrixEventWriter.this.maskReservedLabelCharacters(string);
            }
        }, linkedLabeledIDEvent, oTUListDataAdapter, false);
    }

    protected abstract String maskReservedLabelCharacters(String var1);

    @Override
    protected void doWriteDocument(DocumentDataAdapter documentDataAdapter, Writer writer, ReadWriteParameterMap readWriteParameterMap) throws IOException {
        super.doWriteDocument(documentDataAdapter, writer, readWriteParameterMap);
        ApplicationLogger applicationLogger = readWriteParameterMap.getLogger();
        AbstractSingleMatrixEventWriter.logIngnoredOTULists(documentDataAdapter, applicationLogger, readWriteParameterMap, this.formatName, "sequences");
        Iterator<MatrixDataAdapter> iterator = documentDataAdapter.getMatrixIterator(readWriteParameterMap);
        if (iterator.hasNext()) {
            MatrixDataAdapter matrixDataAdapter = iterator.next();
            Iterator<String> iterator2 = matrixDataAdapter.getSequenceIDIterator(readWriteParameterMap);
            if (iterator2.hasNext()) {
                this.writeSingleMatrix(documentDataAdapter, matrixDataAdapter, iterator2, readWriteParameterMap);
            } else {
                applicationLogger.addWarning("An empty " + this.formatName + " file was written since the first matrix model adapter did not provide any sequences.");
            }
            if (iterator.hasNext()) {
                applicationLogger.addWarning("The specified document adapter contained more than one character matrix adapter. Since the " + this.formatName + " format does not support multiple alignments in one file, only the first matrix was written.");
            }
        } else {
            applicationLogger.addWarning("An empty " + this.formatName + " file was written since the specified document adapter contained contained no matrices.");
        }
        if (documentDataAdapter.getTreeNetworkGroupIterator(readWriteParameterMap).hasNext()) {
            applicationLogger.addWarning("The specified tree or network definitions will not be written, since the " + this.formatName + " format does not support this.");
        }
    }
}

