/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio;

import info.bioinfweb.commons.SystemUtils;
import info.bioinfweb.commons.log.ApplicationLogger;
import info.bioinfweb.jphyloio.JPhyloIO;
import info.bioinfweb.jphyloio.JPhyloIOEventWriter;
import info.bioinfweb.jphyloio.ReadWriteParameterMap;
import info.bioinfweb.jphyloio.WriterStreamDataProvider;
import info.bioinfweb.jphyloio.dataadapters.DocumentDataAdapter;
import info.bioinfweb.jphyloio.dataadapters.ElementDataAdapter;
import info.bioinfweb.jphyloio.dataadapters.JPhyloIOEventReceiver;
import info.bioinfweb.jphyloio.dataadapters.MatrixDataAdapter;
import info.bioinfweb.jphyloio.dataadapters.OTUListDataAdapter;
import info.bioinfweb.jphyloio.events.ConcreteJPhyloIOEvent;
import info.bioinfweb.jphyloio.events.LabeledIDEvent;
import info.bioinfweb.jphyloio.events.LinkedLabeledIDEvent;
import info.bioinfweb.jphyloio.events.SingleSequenceTokenEvent;
import info.bioinfweb.jphyloio.events.type.EventContentType;
import info.bioinfweb.jphyloio.exception.InconsistentAdapterDataException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Iterator;

public abstract class AbstractEventWriter<P extends WriterStreamDataProvider<? extends AbstractEventWriter<P>>>
implements JPhyloIOEventWriter {
    public static final String EDITED_LABEL_SEPARATOR = "_";
    private String indention = "";
    private P streamDataProvider;

    protected P createStreamDataProvider() {
        return (P)new WriterStreamDataProvider<AbstractEventWriter>(this);
    }

    public P getStreamDataProvider() {
        return this.streamDataProvider;
    }

    public static void writeLineBreak(Writer writer, ReadWriteParameterMap readWriteParameterMap) throws IOException {
        writer.write(readWriteParameterMap.getString("info.bioinfweb.jphyloio.lineSeparator", SystemUtils.LINE_SEPARATOR));
    }

    public static void logIngnoredOTULists(DocumentDataAdapter documentDataAdapter, ApplicationLogger applicationLogger, ReadWriteParameterMap readWriteParameterMap, String string, String string2) {
        if (documentDataAdapter.getOTUListIterator(readWriteParameterMap).hasNext()) {
            applicationLogger.addWarning("The specified OTU list(s) will not be written, since the " + string + " format does not support this. Referenced lists will though be used to try to label " + string2 + " if necessary.");
        }
    }

    public static String getLabeledIDName(LabeledIDEvent labeledIDEvent) {
        if (labeledIDEvent.hasLabel()) {
            return labeledIDEvent.getLabel();
        }
        return labeledIDEvent.getID();
    }

    public static String getLinkedOTUNameOwnFirst(LinkedLabeledIDEvent linkedLabeledIDEvent, OTUListDataAdapter oTUListDataAdapter, ReadWriteParameterMap readWriteParameterMap) {
        String string = linkedLabeledIDEvent.getLabel();
        if (string == null) {
            if (linkedLabeledIDEvent.hasLink() && oTUListDataAdapter != null) {
                string = ((LabeledIDEvent)oTUListDataAdapter.getObjectStartEvent(readWriteParameterMap, linkedLabeledIDEvent.getLinkedID())).getLabel();
            }
            if (string == null) {
                string = linkedLabeledIDEvent.getID();
            }
        }
        return string;
    }

    public static String getLinkedOTUNameOTUFirst(LinkedLabeledIDEvent linkedLabeledIDEvent, OTUListDataAdapter oTUListDataAdapter, ReadWriteParameterMap readWriteParameterMap) {
        if (linkedLabeledIDEvent.hasLink() && oTUListDataAdapter != null) {
            return AbstractEventWriter.getLabeledIDName((LabeledIDEvent)oTUListDataAdapter.getObjectStartEvent(readWriteParameterMap, linkedLabeledIDEvent.getLinkedID()));
        }
        return AbstractEventWriter.getLabeledIDName(linkedLabeledIDEvent);
    }

    public static OTUListDataAdapter getReferencedOTUList(DocumentDataAdapter documentDataAdapter, ElementDataAdapter<LinkedLabeledIDEvent> elementDataAdapter, ReadWriteParameterMap readWriteParameterMap) {
        OTUListDataAdapter oTUListDataAdapter = null;
        String string = elementDataAdapter.getStartEvent(readWriteParameterMap).getLinkedID();
        if (string != null) {
            oTUListDataAdapter = documentDataAdapter.getOTUList(readWriteParameterMap, string);
        }
        return oTUListDataAdapter;
    }

    public static long determineMaxSequenceLength(MatrixDataAdapter matrixDataAdapter, ReadWriteParameterMap readWriteParameterMap) {
        long l = matrixDataAdapter.getColumnCount(readWriteParameterMap);
        if (l == -1L) {
            Iterator<String> iterator = matrixDataAdapter.getSequenceIDIterator(readWriteParameterMap);
            while (iterator.hasNext()) {
                l = Math.max(l, matrixDataAdapter.getSequenceLength(readWriteParameterMap, iterator.next()));
            }
        }
        return l;
    }

    protected String getIndention() {
        return this.indention;
    }

    protected void writeLineStart(Writer writer, String string) throws IOException {
        if (this.indention.length() > 0) {
            writer.write(this.indention);
        }
        writer.write(string);
    }

    protected void increaseIndention() {
        this.indention = this.indention + "\t";
    }

    protected void decreaseIndention() {
        if (this.indention.length() > 0) {
            this.indention = this.indention.substring(1);
        }
    }

    private static String createLabel(String string, String string2, int n, UniqueLabelHandler uniqueLabelHandler) {
        string = uniqueLabelHandler.editLabel(string);
        if (string2.length() > n) {
            throw new IllegalArgumentException("The label suffix \"" + string2 + "\" is longer than the specified maximum length (" + n + ").");
        }
        int n2 = string.length() + string2.length() - n;
        if (n2 > 0) {
            return string.substring(0, string.length() - n2) + string2;
        }
        return string + string2;
    }

    public static String createUniqueLabel(ReadWriteParameterMap readWriteParameterMap, UniqueLabelHandler uniqueLabelHandler, String string, String string2, String string3, String string4) {
        int n = readWriteParameterMap.getInteger("info.bioinfweb.jphyloio.maximumNameLength", Integer.MAX_VALUE);
        String string5 = string != null ? AbstractEventWriter.createLabel(string, "", n, uniqueLabelHandler) : (string3 != null ? AbstractEventWriter.createLabel(string3, "", n, uniqueLabelHandler) : string2);
        String string6 = string5;
        if (!uniqueLabelHandler.isUnique(string5) && string != null) {
            if (string3 != null) {
                string5 = string + EDITED_LABEL_SEPARATOR + string3;
            }
            if (!uniqueLabelHandler.isUnique(string5)) {
                string5 = string2 + EDITED_LABEL_SEPARATOR + string;
            }
            if (!uniqueLabelHandler.isUnique(string5) && string3 != null) {
                string5 = string2 + EDITED_LABEL_SEPARATOR + string + EDITED_LABEL_SEPARATOR + string3;
            }
        }
        if (!uniqueLabelHandler.isUnique(string5)) {
            String string7;
            string5 = string6;
            long l = 2L;
            do {
                string7 = AbstractEventWriter.createLabel(string5, EDITED_LABEL_SEPARATOR + l, n, uniqueLabelHandler);
                ++l;
            } while (!uniqueLabelHandler.isUnique(string7));
            string5 = string7;
        }
        return string5;
    }

    public static String createUniqueLabel(ReadWriteParameterMap readWriteParameterMap, UniqueLabelHandler uniqueLabelHandler, LabeledIDEvent labeledIDEvent) {
        String string = AbstractEventWriter.createUniqueLabel(readWriteParameterMap, uniqueLabelHandler, labeledIDEvent.getLabel(), labeledIDEvent.getID(), null, null);
        readWriteParameterMap.getLabelEditingReporter().addEdit(labeledIDEvent, string);
        return string;
    }

    public static String createUniqueLabel(final ReadWriteParameterMap readWriteParameterMap, final LabeledIDEvent labeledIDEvent) {
        return AbstractEventWriter.createUniqueLabel(readWriteParameterMap, new NoEditUniqueLabelHandler(){

            @Override
            public boolean isUnique(String string) {
                return !readWriteParameterMap.getLabelEditingReporter().isLabelUsed(labeledIDEvent.getType().getContentType(), string);
            }
        }, labeledIDEvent);
    }

    public static String createUniqueLinkedOTULabel(ReadWriteParameterMap readWriteParameterMap, UniqueLabelHandler uniqueLabelHandler, LinkedLabeledIDEvent linkedLabeledIDEvent, OTUListDataAdapter oTUListDataAdapter, boolean bl) {
        if (linkedLabeledIDEvent.hasLink() && oTUListDataAdapter != null) {
            try {
                String string = bl ? AbstractEventWriter.createUniqueLabel(readWriteParameterMap, uniqueLabelHandler, ((LabeledIDEvent)oTUListDataAdapter.getObjectStartEvent(readWriteParameterMap, linkedLabeledIDEvent.getLinkedID())).getLabel(), linkedLabeledIDEvent.getLinkedID(), linkedLabeledIDEvent.getLabel(), linkedLabeledIDEvent.getID()) : AbstractEventWriter.createUniqueLabel(readWriteParameterMap, uniqueLabelHandler, linkedLabeledIDEvent.getLabel(), linkedLabeledIDEvent.getID(), ((LabeledIDEvent)oTUListDataAdapter.getObjectStartEvent(readWriteParameterMap, linkedLabeledIDEvent.getLinkedID())).getLabel(), linkedLabeledIDEvent.getLinkedID());
                readWriteParameterMap.getLabelEditingReporter().addEdit(linkedLabeledIDEvent, string);
                return string;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new InconsistentAdapterDataException("The OTU with the ID " + linkedLabeledIDEvent.getLinkedID() + " referenced by the data element with the ID " + linkedLabeledIDEvent.getID() + " was not found in the OTU list with the ID " + ((LabeledIDEvent)oTUListDataAdapter.getStartEvent(readWriteParameterMap)).getID());
            }
        }
        return AbstractEventWriter.createUniqueLabel(readWriteParameterMap, uniqueLabelHandler, linkedLabeledIDEvent);
    }

    protected void extendSequence(MatrixDataAdapter matrixDataAdapter, ReadWriteParameterMap readWriteParameterMap, String string, long l, String string2, JPhyloIOEventReceiver jPhyloIOEventReceiver) throws IOException {
        if (string2 != null) {
            long l2 = l - matrixDataAdapter.getSequenceLength(readWriteParameterMap, string);
            SingleSequenceTokenEvent singleSequenceTokenEvent = new SingleSequenceTokenEvent(null, string2);
            ConcreteJPhyloIOEvent concreteJPhyloIOEvent = ConcreteJPhyloIOEvent.createEndEvent(EventContentType.SINGLE_SEQUENCE_TOKEN);
            for (long i = 0L; i < l2; ++i) {
                jPhyloIOEventReceiver.add(singleSequenceTokenEvent);
                jPhyloIOEventReceiver.add(concreteJPhyloIOEvent);
            }
        }
    }

    protected String getFileStartInfo(ReadWriteParameterMap readWriteParameterMap) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("This file was generated by ");
        if (readWriteParameterMap.getString("info.bioinfweb.jphyloio.applicationName") != null) {
            stringBuffer.append(readWriteParameterMap.getString("info.bioinfweb.jphyloio.applicationName"));
            stringBuffer.append(" ");
            if (readWriteParameterMap.getObject("info.bioinfweb.jphyloio.applicationVersion", null) != null) {
                stringBuffer.append(readWriteParameterMap.getObject("info.bioinfweb.jphyloio.applicationVersion", null).toString());
                stringBuffer.append(" ");
            }
            if (readWriteParameterMap.getString("info.bioinfweb.jphyloio.applicationURL") != null) {
                stringBuffer.append("<");
                stringBuffer.append(readWriteParameterMap.getString("info.bioinfweb.jphyloio.applicationURL"));
                stringBuffer.append("> ");
            }
        } else {
            stringBuffer.append("an application ");
        }
        stringBuffer.append("using ");
        stringBuffer.append(JPhyloIO.getInstance().getLibraryNameAndVersion());
        stringBuffer.append(" <");
        stringBuffer.append(JPhyloIO.getInstance().getProjectURL().toString());
        stringBuffer.append(">.");
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeDocument(DocumentDataAdapter documentDataAdapter, File file, ReadWriteParameterMap readWriteParameterMap) throws IOException {
        try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));){
            this.writeDocument(documentDataAdapter, bufferedWriter, readWriteParameterMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeDocument(DocumentDataAdapter documentDataAdapter, OutputStream outputStream, ReadWriteParameterMap readWriteParameterMap) throws IOException {
        try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);){
            this.writeDocument(documentDataAdapter, outputStreamWriter, readWriteParameterMap);
        }
    }

    @Override
    public void writeDocument(DocumentDataAdapter documentDataAdapter, Writer writer, ReadWriteParameterMap readWriteParameterMap) throws IOException {
        this.streamDataProvider = this.createStreamDataProvider();
        readWriteParameterMap.put("info.bioinfweb.jphyloio.writerInstance", this);
        this.doWriteDocument(documentDataAdapter, writer, readWriteParameterMap);
    }

    protected abstract void doWriteDocument(DocumentDataAdapter var1, Writer var2, ReadWriteParameterMap var3) throws IOException;

    public static abstract class NoEditUniqueLabelHandler
    implements UniqueLabelHandler {
        @Override
        public String editLabel(String string) {
            return string;
        }
    }

    public static interface UniqueLabelHandler {
        public boolean isUnique(String var1);

        public String editLabel(String var1);
    }
}

