/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.commons.log;

import info.bioinfweb.commons.log.AbstractApplicationLogger;
import info.bioinfweb.commons.log.ApplicationLoggerMessage;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.Flushable;
import java.io.IOException;
import java.io.PrintWriter;

public class TextFileApplicationLogger
extends AbstractApplicationLogger
implements Closeable,
Flushable {
    private PrintWriter writer;

    public TextFileApplicationLogger(PrintWriter printWriter) {
        this.writer = printWriter;
    }

    public TextFileApplicationLogger(File file, boolean bl) throws IOException {
        this.writer = new PrintWriter(new BufferedWriter(new FileWriter(file, bl)));
    }

    public TextFileApplicationLogger(File file) throws IOException {
        this(file, true);
    }

    public static TextFileApplicationLogger newStandardOutInstance() {
        return new TextFileApplicationLogger(new PrintWriter(System.out, true));
    }

    public static TextFileApplicationLogger newStandardErrorInstance() {
        return new TextFileApplicationLogger(new PrintWriter(System.err, true));
    }

    @Override
    public synchronized void addMessage(ApplicationLoggerMessage applicationLoggerMessage) {
        this.writer.println(applicationLoggerMessage.toString());
    }

    @Override
    public void close() {
        this.writer.close();
    }

    @Override
    public void flush() {
        this.writer.flush();
    }
}

