/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.commons.log;

import info.bioinfweb.commons.log.ApplicationLogger;
import info.bioinfweb.commons.log.ApplicationLoggerMessage;
import info.bioinfweb.commons.log.ApplicationLoggerMessageType;
import java.io.PrintWriter;
import java.io.StringWriter;

public abstract class AbstractApplicationLogger
implements ApplicationLogger {
    @Override
    public void addMessage(String string, int n) {
        this.addMessage(new ApplicationLoggerMessage(ApplicationLoggerMessageType.MESSAGE, string, n));
    }

    @Override
    public void addMessage(String string) {
        this.addMessage(new ApplicationLoggerMessage(ApplicationLoggerMessageType.MESSAGE, string));
    }

    @Override
    public void addWarning(String string, int n) {
        this.addMessage(new ApplicationLoggerMessage(ApplicationLoggerMessageType.WARNING, string, n));
    }

    @Override
    public void addWarning(String string) {
        this.addMessage(new ApplicationLoggerMessage(ApplicationLoggerMessageType.WARNING, string));
    }

    @Override
    public void addError(String string, int n) {
        this.addMessage(new ApplicationLoggerMessage(ApplicationLoggerMessageType.ERROR, string, n));
    }

    @Override
    public void addError(String string) {
        this.addMessage(new ApplicationLoggerMessage(ApplicationLoggerMessageType.ERROR, string));
    }

    @Override
    public void addError(Throwable throwable, boolean bl) {
        this.addError(throwable, bl, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addError(Throwable throwable, boolean bl, int n) {
        if (bl) {
            StringWriter stringWriter = new StringWriter();
            try (PrintWriter printWriter = new PrintWriter(stringWriter);){
                throwable.printStackTrace(printWriter);
            }
            this.addError(stringWriter.toString(), n);
        } else {
            this.addError(throwable.getLocalizedMessage(), n);
        }
    }
}

