/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.commons.io;

import info.bioinfweb.commons.io.FormatVersion;
import info.bioinfweb.commons.io.InvalidXSDPathException;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class XMLUtils {
    public static final String QNAME_SEPARATOR = ":";
    public static final String ATTR_XSI_NAMESPACE = "xmlns:xsi";
    public static final String ATTR_SCHEMA_LOCATION_LOCAL_PART = "schemaLocation";
    public static final String ATTR_SCHEMA_LOCATION = "xsi:schemaLocation";
    public static final Pattern XSD_FILE_NAME_PATTERN = Pattern.compile(".+/(.+)\\.xsd\\s*", 2);

    public static boolean reachElementEnd(XMLEventReader xMLEventReader) throws XMLStreamException {
        boolean bl = false;
        XMLEvent xMLEvent = xMLEventReader.nextEvent();
        while (xMLEvent.getEventType() != 2) {
            if (xMLEvent.getEventType() != 6 && xMLEvent.getEventType() != 4) {
                bl = true;
            } else if (xMLEvent.getEventType() == 4) {
                boolean bl2 = bl = bl || !xMLEvent.asCharacters().getData().trim().equals("");
            }
            if (xMLEvent.getEventType() == 1) {
                XMLUtils.reachElementEnd(xMLEventReader);
            }
            xMLEvent = xMLEventReader.nextEvent();
        }
        return bl;
    }

    public static boolean reachElementEnd(XMLStreamReader xMLStreamReader) throws XMLStreamException {
        boolean bl = false;
        while (xMLStreamReader.next() != 2) {
            if (xMLStreamReader.getEventType() != 6 && xMLStreamReader.getEventType() != 4) {
                bl = true;
            } else if (xMLStreamReader.getEventType() == 4) {
                boolean bl2 = bl = bl || !xMLStreamReader.getText().trim().equals("");
            }
            if (xMLStreamReader.getEventType() != 1) continue;
            XMLUtils.reachElementEnd(xMLStreamReader);
        }
        return bl;
    }

    public static String readStringAttr(StartElement startElement, QName qName, String string) {
        Attribute attribute = startElement.getAttributeByName(qName);
        if (attribute == null) {
            return string;
        }
        return attribute.getValue();
    }

    public static boolean readBooleanAttr(StartElement startElement, QName qName, boolean bl) {
        Attribute attribute = startElement.getAttributeByName(qName);
        if (attribute == null) {
            return bl;
        }
        return Boolean.parseBoolean(attribute.getValue());
    }

    public static int readIntAttr(StartElement startElement, QName qName, int n) {
        Attribute attribute = startElement.getAttributeByName(qName);
        if (attribute == null) {
            return n;
        }
        return Integer.parseInt(attribute.getValue());
    }

    public static float readFloatAttr(StartElement startElement, QName qName, float f) {
        Attribute attribute = startElement.getAttributeByName(qName);
        if (attribute == null) {
            return f;
        }
        return Float.parseFloat(attribute.getValue());
    }

    public static double readDoubleAttr(StartElement startElement, QName qName, double d) {
        Attribute attribute = startElement.getAttributeByName(qName);
        if (attribute == null) {
            return d;
        }
        return Double.parseDouble(attribute.getValue());
    }

    public static Color readColorAttr(StartElement startElement, QName qName, Color color) {
        Attribute attribute = startElement.getAttributeByName(qName);
        if (attribute == null) {
            return color;
        }
        String string = attribute.getValue();
        int n = Integer.parseInt(string.subSequence(1, 3).toString(), 16);
        int n2 = Integer.parseInt(string.subSequence(3, 5).toString(), 16);
        int n3 = Integer.parseInt(string.subSequence(5, 7).toString(), 16);
        return new Color(n, n2, n3);
    }

    public static boolean isCharacterType(int n) {
        return n == 4 || n == 12 || n == 6;
    }

    public static String readCharactersAsString(XMLEventReader xMLEventReader) throws XMLStreamException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = xMLEventReader.peek().getEventType();
        while (XMLUtils.isCharacterType(n) || n == 5) {
            XMLEvent xMLEvent = xMLEventReader.nextEvent();
            if (XMLUtils.isCharacterType(xMLEvent.getEventType())) {
                stringBuffer.append(xMLEvent.asCharacters().getData());
            }
            n = xMLEventReader.peek().getEventType();
        }
        return stringBuffer.toString();
    }

    public static String readCharactersAsString(XMLStreamReader xMLStreamReader) throws XMLStreamException {
        StringBuffer stringBuffer = new StringBuffer();
        while (XMLUtils.isCharacterType(xMLStreamReader.getEventType()) || xMLStreamReader.getEventType() == 5) {
            if (XMLUtils.isCharacterType(xMLStreamReader.getEventType())) {
                stringBuffer.append(xMLStreamReader.getText());
            }
            xMLStreamReader.next();
        }
        return stringBuffer.toString();
    }

    public static boolean readCharactersAsBoolean(XMLEventReader xMLEventReader) throws XMLStreamException {
        return Boolean.parseBoolean(XMLUtils.readCharactersAsString(xMLEventReader));
    }

    public static boolean readCharactersAsBoolean(XMLStreamReader xMLStreamReader) throws XMLStreamException {
        return Boolean.parseBoolean(XMLUtils.readCharactersAsString(xMLStreamReader));
    }

    public static int readCharactersAsInt(XMLEventReader xMLEventReader) throws XMLStreamException {
        return Integer.parseInt(XMLUtils.readCharactersAsString(xMLEventReader));
    }

    public static int readCharactersAsInt(XMLStreamReader xMLStreamReader) throws XMLStreamException {
        return Integer.parseInt(XMLUtils.readCharactersAsString(xMLStreamReader));
    }

    public static long readCharactersAsLong(XMLEventReader xMLEventReader) throws XMLStreamException {
        return Long.parseLong(XMLUtils.readCharactersAsString(xMLEventReader));
    }

    public static long readCharactersAsLong(XMLStreamReader xMLStreamReader) throws XMLStreamException {
        return Long.parseLong(XMLUtils.readCharactersAsString(xMLStreamReader));
    }

    public static float readCharactersAsFloat(XMLEventReader xMLEventReader) throws XMLStreamException {
        return Float.parseFloat(XMLUtils.readCharactersAsString(xMLEventReader));
    }

    public static float readCharactersAsFloat(XMLStreamReader xMLStreamReader) throws XMLStreamException {
        return Float.parseFloat(XMLUtils.readCharactersAsString(xMLStreamReader));
    }

    public static double readCharactersAsDouble(XMLEventReader xMLEventReader) throws XMLStreamException {
        return Double.parseDouble(XMLUtils.readCharactersAsString(xMLEventReader));
    }

    public static double readCharactersAsDouble(XMLStreamReader xMLStreamReader) throws XMLStreamException {
        return Double.parseDouble(XMLUtils.readCharactersAsString(xMLStreamReader));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StartElement readRootElement(InputStream inputStream) throws IOException, XMLStreamException {
        XMLEventReader xMLEventReader = XMLInputFactory.newInstance().createXMLEventReader(inputStream);
        StartElement startElement = null;
        try {
            while (xMLEventReader.hasNext() && startElement == null) {
                XMLEvent xMLEvent = xMLEventReader.nextEvent();
                if (xMLEvent.getEventType() != 1) continue;
                startElement = xMLEvent.asStartElement();
            }
        }
        finally {
            xMLEventReader.close();
            inputStream.close();
        }
        return startElement;
    }

    public static StartElement readRootElement(File file) throws IOException, XMLStreamException {
        return XMLUtils.readRootElement(new FileInputStream(file));
    }

    public static void writeNamespaceAttr(XMLStreamWriter xMLStreamWriter, String string) throws XMLStreamException {
        xMLStreamWriter.writeAttribute("xmlns", string);
    }

    public static void writeNamespaceXSDAttr(XMLStreamWriter xMLStreamWriter, String string, String string2) throws XMLStreamException {
        XMLUtils.writeNamespaceAttr(xMLStreamWriter, string);
        xMLStreamWriter.writeAttribute(ATTR_XSI_NAMESPACE, "http://www.w3.org/2001/XMLSchema-instance");
        xMLStreamWriter.writeAttribute(ATTR_SCHEMA_LOCATION, string + " " + string2);
    }

    public static String extractXSDFileName(StartElement startElement) throws InvalidXSDPathException {
        Attribute attribute = startElement.getAttributeByName(new QName("http://www.w3.org/2001/XMLSchema-instance", ATTR_SCHEMA_LOCATION_LOCAL_PART));
        if (attribute == null) {
            return null;
        }
        Matcher matcher = XSD_FILE_NAME_PATTERN.matcher(attribute.getValue());
        if (matcher.matches()) {
            return matcher.group(1);
        }
        throw new InvalidXSDPathException("The attrubute value \"" + attribute.getValue() + "\" does not contain a valid path.");
    }

    public static FormatVersion extractFormatVersion(StartElement startElement) throws InvalidXSDPathException {
        String string = XMLUtils.extractXSDFileName(startElement);
        if (string == null) {
            return null;
        }
        try {
            return FormatVersion.parseFormatVersion(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidXSDPathException("The XSD file name \"" + string + "\" does not specify a valid format version.");
        }
    }

    public static void writeStartElement(XMLStreamWriter xMLStreamWriter, QName qName) throws XMLStreamException {
        xMLStreamWriter.writeStartElement(qName.getPrefix(), qName.getLocalPart(), qName.getNamespaceURI());
    }

    public static void writeAttribute(XMLStreamWriter xMLStreamWriter, QName qName, String string) throws XMLStreamException, IllegalStateException {
        xMLStreamWriter.writeAttribute(qName.getPrefix(), qName.getNamespaceURI(), qName.getLocalPart(), string);
    }
}

