/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.commons.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;

public class TextReader {
    public static String readText(URL uRL) throws IOException {
        return TextReader.readText(uRL.openStream());
    }

    public static String readText(File file) throws IOException {
        if (file.length() > Integer.MAX_VALUE) {
            throw new IOException("The file \"" + file.getAbsolutePath() + "\" is too large to be loaded to a string.");
        }
        return TextReader.readText(new FileInputStream(file), (int)file.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readText(InputStream inputStream) throws IOException {
        CharSequence charSequence;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        try {
            charSequence = bufferedReader.readLine();
            while (charSequence != null) {
                arrayList.add((String)charSequence);
                n += ((String)charSequence).length() + 1;
                charSequence = bufferedReader.readLine();
            }
        }
        finally {
            bufferedReader.close();
        }
        charSequence = new StringBuilder(n);
        for (int i = 0; i < arrayList.size(); ++i) {
            ((StringBuilder)charSequence).append((String)arrayList.get(i) + "\n");
        }
        arrayList.clear();
        return ((StringBuilder)charSequence).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readText(InputStream inputStream, int n) throws IOException {
        StringBuilder stringBuilder = new StringBuilder(n);
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));){
            String string = bufferedReader.readLine();
            while (string != null) {
                stringBuilder.append(string + "\n");
                string = bufferedReader.readLine();
            }
        }
        return stringBuilder.toString();
    }
}

