/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.commons.io;

import info.bioinfweb.commons.io.ClosingNotAllowedException;
import java.io.IOException;
import java.io.Reader;

public class LimitedReader
extends Reader {
    private Reader decoratedReader;
    private long limit;
    private long position = 0L;
    private long markPosition = 0L;
    private boolean allowClose = true;

    public LimitedReader(Reader reader, long l) {
        if (reader == null) {
            throw new NullPointerException("The decorated reader must not be null.");
        }
        if (l < 0L) {
            throw new IllegalArgumentException("The read limit must not be lower than 0, but was " + l + ".");
        }
        this.decoratedReader = reader;
        this.limit = l;
    }

    public long getLimit() {
        return this.limit;
    }

    public long availableCharacters() {
        return this.limit - this.position;
    }

    public boolean isLimitReached() {
        return this.availableCharacters() == 0L;
    }

    public boolean isAllowClose() {
        return this.allowClose;
    }

    public void setAllowClose(boolean bl) {
        this.allowClose = bl;
    }

    @Override
    public void close() throws IOException {
        if (!this.allowClose) {
            throw new ClosingNotAllowedException();
        }
        this.decoratedReader.close();
    }

    @Override
    public int read(char[] cArray, int n, int n2) throws IOException {
        if (this.isLimitReached()) {
            return -1;
        }
        n2 = (int)Math.min((long)n2, this.availableCharacters());
        int n3 = this.decoratedReader.read(cArray, n, n2);
        this.position += (long)n3;
        return n3;
    }

    @Override
    public long skip(long l) throws IOException {
        l = Math.min(l, this.availableCharacters());
        long l2 = this.decoratedReader.skip(l);
        this.position += l2;
        return l2;
    }

    @Override
    public synchronized void mark(int n) throws IOException {
        n = (int)Math.min((long)n, this.availableCharacters());
        this.markPosition = this.position;
        this.decoratedReader.mark(n);
    }

    @Override
    public boolean markSupported() {
        return this.decoratedReader.markSupported();
    }

    @Override
    public boolean ready() throws IOException {
        return !this.isLimitReached() && this.decoratedReader.ready();
    }

    @Override
    public synchronized void reset() throws IOException {
        this.decoratedReader.reset();
        this.position = this.markPosition;
    }
}

