/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.commons.io;

import info.bioinfweb.commons.io.ClosingNotAllowedException;
import java.io.IOException;
import java.io.InputStream;

public class LimitedInputStream
extends InputStream {
    private InputStream decoratedStream;
    private long limit;
    private long position = 0L;
    private long markPosition = 0L;
    private boolean allowClose = true;

    public LimitedInputStream(InputStream inputStream, long l) {
        if (inputStream == null) {
            throw new NullPointerException("The decorated input stream must not be null.");
        }
        if (l < 0L) {
            throw new IllegalArgumentException("The read limit must not be lower than 0, but was " + l + ".");
        }
        this.decoratedStream = inputStream;
        this.limit = l;
    }

    public long getLimit() {
        return this.limit;
    }

    public long availableCharacters() {
        return this.limit - this.position;
    }

    public boolean isLimitReached() {
        return this.availableCharacters() == 0L;
    }

    public boolean isAllowClose() {
        return this.allowClose;
    }

    public void setAllowClose(boolean bl) {
        this.allowClose = bl;
    }

    @Override
    public void close() throws IOException {
        if (!this.allowClose) {
            throw new ClosingNotAllowedException();
        }
        this.decoratedStream.close();
    }

    @Override
    public int read() throws IOException {
        if (this.isLimitReached()) {
            return -1;
        }
        int n = this.decoratedStream.read();
        if (n > -1) {
            ++this.position;
        }
        return n;
    }

    @Override
    public boolean markSupported() {
        return this.decoratedStream.markSupported();
    }

    @Override
    public int available() throws IOException {
        return (int)Math.min(this.availableCharacters(), (long)this.decoratedStream.available());
    }

    @Override
    public synchronized void mark(int n) {
        n = (int)Math.min((long)n, this.availableCharacters());
        this.markPosition = this.position;
        this.decoratedStream.mark(n);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.decoratedStream.reset();
        this.position = this.markPosition;
    }

    @Override
    public long skip(long l) throws IOException {
        l = Math.min(l, this.availableCharacters());
        long l2 = this.decoratedStream.skip(l);
        this.position += l2;
        return l2;
    }
}

