/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.commons.io;

public class FormatVersion
implements Comparable<FormatVersion>,
Cloneable {
    private int major = 1;
    private int minor = 0;

    public FormatVersion(int n, int n2) {
        this.major = n;
        this.minor = n2;
    }

    public int getMajor() {
        return this.major;
    }

    public void setMajor(int n) {
        this.major = n;
    }

    public int getMinor() {
        return this.minor;
    }

    public void setMinor(int n) {
        this.minor = n;
    }

    public static FormatVersion parseFormatVersion(String string) {
        String[] stringArray = string.trim().split("\\.");
        if (stringArray.length == 2) {
            try {
                return new FormatVersion(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new IllegalArgumentException("The specified string \"" + string + "\" cannot be parsed as a format version.");
    }

    public boolean geraterThan(FormatVersion formatVersion) {
        return this.getMajor() > formatVersion.getMajor() || this.getMajor() == formatVersion.getMajor() && this.getMinor() > formatVersion.getMinor();
    }

    @Override
    public int compareTo(FormatVersion formatVersion) {
        if (this.getMajor() == formatVersion.getMajor() && this.getMinor() == formatVersion.getMinor()) {
            return 0;
        }
        if (this.getMajor() > formatVersion.getMajor() || this.getMajor() == formatVersion.getMajor() && this.getMinor() > formatVersion.getMinor()) {
            return 1;
        }
        return -1;
    }

    public FormatVersion clone() {
        return new FormatVersion(this.getMajor(), this.getMinor());
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.major;
        n = 31 * n + this.minor;
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        FormatVersion formatVersion = (FormatVersion)object;
        if (this.major != formatVersion.major) {
            return false;
        }
        return this.minor == formatVersion.minor;
    }

    public String toString() {
        return this.getMajor() + "." + this.getMinor();
    }
}

