/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.commons.io;

import info.bioinfweb.commons.changemonitor.ChangeMonitor;
import info.bioinfweb.commons.changemonitor.ChangeMonitorable;
import info.bioinfweb.commons.io.Savable;
import java.io.File;
import java.util.Vector;

public abstract class AbstractSaver
extends ChangeMonitor
implements ChangeMonitorable,
Savable {
    private File file;
    private String defaultName;
    private Vector<String> fileExtensions = new Vector();
    private String defaultExtension = "";

    @Override
    public void addFileExtension(String string) {
        this.fileExtensions.add(string.toLowerCase());
    }

    @Override
    public String getDefaultExtension() {
        return this.defaultExtension;
    }

    @Override
    public String[] getFileExtensions() {
        return this.fileExtensions.toArray(new String[this.fileExtensions.size()]);
    }

    @Override
    public void removeFileExtention(String string) {
        this.fileExtensions.remove(string.toLowerCase());
    }

    @Override
    public void setDefaultExtension(String string) {
        this.removeFileExtention(this.getDefaultExtension());
        this.defaultExtension = string;
        this.addFileExtension(string);
    }

    @Override
    public boolean endsWithDefaultExt(String string) {
        return string.toLowerCase().endsWith(this.getDefaultExtension());
    }

    @Override
    public boolean endsWithValidExt(String string) {
        string = string.toLowerCase();
        for (int i = 0; i < this.fileExtensions.size(); ++i) {
            if (!string.endsWith(this.fileExtensions.get(i))) continue;
            return true;
        }
        return false;
    }

    protected abstract void saveDataToFile(File var1);

    @Override
    public abstract boolean askToSave();

    @Override
    public String getDefaultName() {
        return this.defaultName;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public boolean hasFile() {
        return this.file != null;
    }

    @Override
    public String getDefaultNameOrPath() {
        if (this.hasFile()) {
            return this.getFile().getAbsolutePath();
        }
        return this.getDefaultName();
    }

    @Override
    public boolean save() {
        if (this.hasFile()) {
            this.saveDataToFile(this.getFile());
            this.reset();
            return true;
        }
        return this.saveAs();
    }

    @Override
    public abstract boolean saveAs();

    @Override
    public void setDefaultName(String string) {
        this.defaultName = string;
    }

    @Override
    public void setFile(File file) {
        this.file = file;
    }
}

