/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.commons.graphics;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Map;

public class FontCalculator {
    private static final int TEST_FONT_HEIGHT = 512;
    private static FontCalculator firstInstance = null;
    private final FontRenderContext frc = new FontRenderContext(null, true, true);
    private final Map<String, Float> sizeHeightRatioMap = new HashMap<String, Float>();

    private FontCalculator() {
    }

    public static FontCalculator getInstance() {
        if (firstInstance == null) {
            firstInstance = new FontCalculator();
        }
        return firstInstance;
    }

    private String getMapKey(String string, int n) {
        return string + "\t\t\t" + n;
    }

    public float getHeightSizeRatio(String string, int n) {
        String string2 = this.getMapKey(string, n);
        Float f = this.sizeHeightRatioMap.get(string2);
        if (f == null) {
            Font font = new Font(string, n, 512);
            f = Float.valueOf((float)(font.getStringBounds("\u00d6g", this.frc).getHeight() / (double)font.getSize2D()));
            this.sizeHeightRatioMap.put(string2, f);
        }
        return f.floatValue();
    }

    public float getTextHeightByFontSize(float f, String string, int n) {
        return this.getHeightSizeRatio(string, n) * f;
    }

    public float getTextHeightByFontSize(Font font) {
        return this.getTextHeightByFontSize(font.getSize2D(), font.getFontName(), font.getStyle());
    }

    public float getFontSizeByTextHeight(float f, String string, int n) {
        return f / this.getHeightSizeRatio(string, n);
    }

    public float getDescent(Font font) {
        return new TextLayout("\u00d6g", font, this.frc).getDescent();
    }

    public float getAscent(Font font) {
        return new TextLayout("\u00d6g", font, this.frc).getAscent();
    }

    @Deprecated
    public float getHeight(Font font) {
        return (float)font.getStringBounds("\u00d6g", this.frc).getHeight();
    }

    public float getWidth(Font font, String string) {
        if (string.length() > 0) {
            return (float)font.getStringBounds(string, this.frc).getWidth();
        }
        return 0.0f;
    }

    public float getAspectRatio(Font font, String string) {
        Rectangle2D rectangle2D = font.getStringBounds(string, this.frc);
        return (float)(rectangle2D.getWidth() / rectangle2D.getHeight());
    }

    @Deprecated
    public float getWidthToHeigth(String string, int n, String string2, float f) {
        return this.getTextWidthToTextHeigth(string, n, string2, f);
    }

    public float getTextWidthToTextHeigth(String string, int n, String string2, float f) {
        return this.getTextWidthToFontSize(string, n, string2, this.getFontSizeByTextHeight(f, string, n));
    }

    public float getTextWidthToFontSize(String string, int n, String string2, float f) {
        if (string2.length() > 0) {
            Font font = new Font(string, n, 512);
            return (float)(font.getStringBounds(string2, this.frc).getWidth() * (double)(f / font.getSize2D()));
        }
        return 0.0f;
    }

    public float getDescentToHeight(String string, int n, float f) {
        TextLayout textLayout = new TextLayout("\u00d6g", new Font(string, n, 512), this.frc);
        return f * (textLayout.getDescent() / (textLayout.getDescent() + textLayout.getAscent()));
    }

    public float getAscentToHeight(String string, int n, float f) {
        TextLayout textLayout = new TextLayout("\u00d6g", new Font(string, n, 512), this.frc);
        return f * (textLayout.getAscent() / (textLayout.getDescent() + textLayout.getAscent()));
    }

    public Font fontToFitRectangle(Rectangle2D rectangle2D, double d, String string, String string2, int n) {
        return this.fontToFitRectangle(rectangle2D, d, string, string2, n, 0);
    }

    public Font fontToFitRectangle(Rectangle2D rectangle2D, double d, String string, String string2, int n, int n2) {
        Font font = null;
        int n3 = (int)Math.round(rectangle2D.getHeight() * d);
        if (n3 < n2) {
            return null;
        }
        font = new Font(string2, n, n3);
        double d2 = this.getAspectRatio(font, string);
        if (d2 * rectangle2D.getHeight() > rectangle2D.getWidth()) {
            n3 = (int)Math.round(rectangle2D.getWidth() / d2 * d);
            if (n3 < n2) {
                return null;
            }
            font = new Font(string2, n, n3);
        }
        return font;
    }
}

