/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.commons.graphics;

import java.awt.Color;
import java.awt.image.BufferedImage;

public class AlphaImageAssembler {
    private static Color extractRGB(int n) {
        return new Color(n >> 16 & 0xFF, n >> 8 & 0xFF, n & 0xFF);
    }

    private static int packARGB(int n, int n2, int n3, int n4) {
        return n << 24 | n2 << 16 | n3 << 8 | n4;
    }

    private static int originalColor(int n, int n2) {
        if (n2 == 0 || n2 == 255) {
            return n;
        }
        return Math.min(255, Math.max(0, n * 255 / n2));
    }

    public static BufferedImage assemble(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        if (bufferedImage.getWidth() != bufferedImage2.getWidth() || bufferedImage.getHeight() != bufferedImage2.getHeight()) {
            return null;
        }
        BufferedImage bufferedImage3 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 2);
        for (int i = 0; i < bufferedImage3.getWidth(); ++i) {
            for (int j = 0; j < bufferedImage3.getHeight(); ++j) {
                Color color = AlphaImageAssembler.extractRGB(bufferedImage.getRGB(i, j));
                Color color2 = AlphaImageAssembler.extractRGB(bufferedImage2.getRGB(i, j));
                int n = color.getRed() != color2.getRed() ? color.getRed() - color2.getRed() + 255 : (color.getGreen() != color2.getGreen() ? color.getGreen() - color2.getGreen() + 255 : color.getBlue() - color2.getBlue() + 255);
                n = Math.max(0, Math.min(255, n));
                bufferedImage3.setRGB(i, j, AlphaImageAssembler.packARGB(n, AlphaImageAssembler.originalColor(color.getRed(), n), AlphaImageAssembler.originalColor(color.getGreen(), n), AlphaImageAssembler.originalColor(color.getBlue(), n)));
            }
        }
        return bufferedImage3;
    }
}

