/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.commons.collections;

import com.google.common.collect.TreeMultiset;
import info.bioinfweb.commons.Math2;
import info.bioinfweb.commons.collections.SequenceIntervalPositionAdapter;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.SortedSet;
import java.util.TreeSet;

public class SequenceIntervalList<E>
implements Collection<E> {
    public static final int DEFAULT_INITIAL_SEQUENCE_LENGTH = 5000;
    public static final int DEFAULT_INTERVAL_LENGTH = 50;
    private ArrayList<IntervalInformation> intervalList;
    private int size = 0;
    private int intervalLength;
    private SequenceIntervalPositionAdapter<? super E> positionAdapter;

    public SequenceIntervalList(SequenceIntervalPositionAdapter<? super E> sequenceIntervalPositionAdapter) {
        this(sequenceIntervalPositionAdapter, 5000, 50);
    }

    public SequenceIntervalList(SequenceIntervalPositionAdapter<? super E> sequenceIntervalPositionAdapter, int n, int n2) {
        this.positionAdapter = sequenceIntervalPositionAdapter;
        this.intervalLength = n2;
        this.intervalList = new ArrayList(n / n2 + 1);
    }

    public int getIntervalLength() {
        return this.intervalLength;
    }

    public SequenceIntervalPositionAdapter<? super E> getPositionAdapter() {
        return this.positionAdapter;
    }

    private void resortElements() {
        ArrayList arrayList = new ArrayList(this.size());
        arrayList.addAll(this);
        this.clear();
        this.addAll(arrayList);
    }

    public void setPositionAdapter(SequenceIntervalPositionAdapter<? super E> sequenceIntervalPositionAdapter) {
        this.positionAdapter = sequenceIntervalPositionAdapter;
        this.resortElements();
    }

    private int intervalIndex(int n) {
        return n / this.getIntervalLength();
    }

    private IntervalInformation getIntervalInformation(int n) {
        while (n >= this.intervalList.size()) {
            this.intervalList.add(new IntervalInformation(this.intervalList.size() * this.getIntervalLength(), this.getPositionAdapter()));
        }
        return this.intervalList.get(n);
    }

    private Iterator<IntervalInformation> getIntervalInformationIterator(int n, int n2) {
        LinkedList<IntervalInformation> linkedList = new LinkedList<IntervalInformation>();
        int n3 = this.intervalIndex(n);
        int n4 = this.intervalIndex(n2);
        for (int i = n3; i <= n4; ++i) {
            linkedList.add(this.getIntervalInformation(i));
        }
        return linkedList.iterator();
    }

    @Override
    public boolean add(E e) {
        Iterator<IntervalInformation> iterator = this.getIntervalInformationIterator(this.getPositionAdapter().getFirstPos(e), this.getPositionAdapter().getLastPos(e));
        boolean bl = true;
        while (iterator.hasNext()) {
            bl = bl && iterator.next().add(e);
        }
        ++this.size;
        return bl;
    }

    @Override
    public boolean remove(Object object) {
        try {
            Object object2 = object;
            Iterator<IntervalInformation> iterator = this.getIntervalInformationIterator(this.getPositionAdapter().getFirstPos(object2), this.getPositionAdapter().getLastPos(object2));
            boolean bl = true;
            while (iterator.hasNext()) {
                bl = bl && iterator.next().remove(object2);
            }
            if (bl) {
                --this.size;
            }
            return bl;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public boolean move(E e, int n, int n2) {
        if (this.remove(e)) {
            this.getPositionAdapter().setFirstPos(e, n);
            this.getPositionAdapter().setLastPos(e, n2);
            this.add(e);
            return true;
        }
        return false;
    }

    private void addOverlappingElementsFromList(Collection<E> collection, Collection<E> collection2, int n, int n2) {
        for (E e : collection2) {
            if (!Math2.overlaps(n, n2, this.getPositionAdapter().getFirstPos(e), this.getPositionAdapter().getLastPos(e))) continue;
            collection.add(e);
        }
    }

    public SortedSet<E> getOverlappingElements(int n, int n2) {
        TreeSet<E> treeSet = new TreeSet<E>(this.getPositionAdapter());
        Iterator<IntervalInformation> iterator = this.getIntervalInformationIterator(n, n2);
        if (iterator.hasNext()) {
            IntervalInformation intervalInformation = iterator.next();
            this.addOverlappingElementsFromList(treeSet, (Collection<E>)intervalInformation.getOverlapList(), n, n2);
            this.addOverlappingElementsFromList(treeSet, (Collection<E>)intervalInformation.getStartList(), n, n2);
            while (iterator.hasNext()) {
                this.addOverlappingElementsFromList(treeSet, (Collection<E>)iterator.next().getStartList(), n, n2);
            }
        }
        return treeSet;
    }

    private boolean collectionContainsPosition(Collection<E> collection, int n) {
        for (E e : collection) {
            if (!Math2.isBetween(n, this.getPositionAdapter().getFirstPos(e), this.getPositionAdapter().getLastPos(e))) continue;
            return true;
        }
        return false;
    }

    public boolean containsPosition(int n) {
        IntervalInformation intervalInformation = this.getIntervalInformation(this.intervalIndex(n));
        if (this.collectionContainsPosition((Collection<E>)intervalInformation.getOverlapList(), n)) {
            return true;
        }
        return this.collectionContainsPosition((Collection<E>)intervalInformation.getStartList(), n);
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        boolean bl = true;
        for (E e : collection) {
            bl = bl && this.add(e);
        }
        return bl;
    }

    @Override
    public void clear() {
        this.intervalList.clear();
        this.size = 0;
    }

    @Override
    public boolean contains(Object object) {
        try {
            return this.getIntervalInformation(this.intervalIndex(this.getPositionAdapter().getFirstPos(object))).getStartList().contains(object);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        for (Object obj : collection) {
            boolean bl = this.contains(obj);
            if (bl) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            private Iterator<IntervalInformation> intervalIterator;
            private Iterator<E> listIterator;
            {
                this.intervalIterator = SequenceIntervalList.this.intervalList.iterator();
                this.listIterator = null;
            }

            private boolean secureFilledListIterator() {
                if ((this.listIterator == null || !this.listIterator.hasNext()) && this.intervalIterator.hasNext()) {
                    do {
                        this.listIterator = this.intervalIterator.next().getStartList().iterator();
                    } while (!this.listIterator.hasNext() && this.intervalIterator.hasNext());
                }
                return this.listIterator != null && this.listIterator.hasNext();
            }

            @Override
            public boolean hasNext() {
                return this.secureFilledListIterator();
            }

            @Override
            public E next() {
                this.secureFilledListIterator();
                return this.listIterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean bl = true;
        for (Object obj : collection) {
            bl = bl && this.remove(obj);
        }
        return bl;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        Iterator<E> iterator = this.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            E e = iterator.next();
            if (collection.contains(e)) continue;
            bl = bl && this.remove(e);
        }
        return bl;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new Object[this.size()]);
    }

    @Override
    public <T> T[] toArray(T[] objectArray) {
        if (objectArray.length < this.size()) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this.size());
        }
        Iterator<E> iterator = this.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            objectArray[n] = iterator.next();
            ++n;
        }
        return objectArray;
    }

    protected class IntervalInformation {
        private int intervalStart;
        private TreeMultiset<E> startList;
        private TreeMultiset<E> overlapList;

        public IntervalInformation(int n, Comparator<E> comparator) {
            this.intervalStart = n;
            this.startList = TreeMultiset.create(comparator);
            this.overlapList = TreeMultiset.create(comparator);
        }

        public int getIntervalStart() {
            return this.intervalStart;
        }

        public TreeMultiset<E> getStartList() {
            return this.startList;
        }

        public TreeMultiset<E> getOverlapList() {
            return this.overlapList;
        }

        public boolean add(E e) {
            int n;
            int n2 = SequenceIntervalList.this.getPositionAdapter().getFirstPos(e);
            if (n2 > (n = this.getIntervalStart() + SequenceIntervalList.this.getIntervalLength() - 1)) {
                return false;
            }
            if (n2 < this.getIntervalStart()) {
                return this.getOverlapList().add(e);
            }
            return this.getStartList().add(e);
        }

        public boolean remove(E e) {
            if (Math2.isBetween(SequenceIntervalList.this.getPositionAdapter().getFirstPos(e), this.getIntervalStart(), this.getIntervalStart() + SequenceIntervalList.this.getIntervalLength() - 1)) {
                return this.getStartList().remove(e);
            }
            return this.getOverlapList().remove(e);
        }

        public void clear() {
            this.getStartList().clear();
            this.getOverlapList().clear();
        }
    }
}

