/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.commons.collections;

import info.bioinfweb.commons.Math2;
import info.bioinfweb.commons.collections.PackedIntegerArrayList;
import java.util.AbstractList;

public abstract class PackedPrimitiveWrapperArrayList<E extends Number>
extends AbstractList<E> {
    protected PackedIntegerArrayList packedList;

    protected PackedPrimitiveWrapperArrayList(int n, long l, int n2) {
        this.packedList = new PackedIntegerArrayList(n, l, n2);
    }

    private static void checkParameters(int n, int n2, long l, long l2) {
        if (n <= 0 || n > n2) {
            throw new IllegalArgumentException("At least 1 and at most " + n2 + " bits per value are allowed to be used.");
        }
        long l3 = l + Math2.longPow(2L, n) - 1L;
        if (l3 > l2) {
            throw new IllegalArgumentException("The specified combination of bitsPerValue (" + n + ") and minValue (" + l + ") cannot be represented by the specified primitive type.");
        }
    }

    public static PackedPrimitiveWrapperArrayList<Byte> newByteInstance(int n, long l, int n2) {
        PackedPrimitiveWrapperArrayList.checkParameters(n, 8, l, 127L);
        return new PackedPrimitiveWrapperArrayList<Byte>(n, l, n2){

            @Override
            public Byte get(int n) {
                return new Byte((byte)this.packedList.get(n));
            }
        };
    }

    public static PackedPrimitiveWrapperArrayList<Short> newShortInstance(int n, long l, int n2) {
        PackedPrimitiveWrapperArrayList.checkParameters(n, 16, l, 32767L);
        return new PackedPrimitiveWrapperArrayList<Short>(n, l, n2){

            @Override
            public Short get(int n) {
                return new Short((short)this.packedList.get(n));
            }
        };
    }

    public static PackedPrimitiveWrapperArrayList<Integer> newIntegerInstance(int n, long l, int n2) {
        PackedPrimitiveWrapperArrayList.checkParameters(n, 32, l, Integer.MAX_VALUE);
        return new PackedPrimitiveWrapperArrayList<Integer>(n, l, n2){

            @Override
            public Integer get(int n) {
                return new Integer((int)this.packedList.get(n));
            }
        };
    }

    public static PackedPrimitiveWrapperArrayList<Long> newLongInstance(int n, long l, int n2) {
        PackedPrimitiveWrapperArrayList.checkParameters(n, 63, l, Long.MAX_VALUE);
        return new PackedPrimitiveWrapperArrayList<Long>(n, l, n2){

            @Override
            public Long get(int n) {
                return new Long(this.packedList.get(n));
            }
        };
    }

    @Override
    public void add(int n, E e) {
        this.packedList.add(n, ((Number)e).longValue());
    }

    @Override
    public E remove(int n) {
        Number number = (Number)this.get(n);
        this.packedList.remove(n);
        return (E)number;
    }

    @Override
    protected void removeRange(int n, int n2) {
        this.packedList.removeRange(n, n2 - n);
    }

    @Override
    public E set(int n, E e) {
        Number number = (Number)this.get(n);
        this.packedList.set(n, ((Number)e).longValue());
        return (E)number;
    }

    @Override
    public int size() {
        return (int)this.packedList.size();
    }
}

