/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.commons.collections;

import info.bioinfweb.commons.collections.PackedIntegerArrayList;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PackedObjectArrayList<E>
extends AbstractList<E>
implements List<E> {
    private PackedIntegerArrayList packedList;
    private List<E> objectList;
    private Map<E, Integer> intMap;

    public PackedObjectArrayList(int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("A negative objectTypeCount (" + n + ") is not valid.");
        }
        this.packedList = new PackedIntegerArrayList(PackedIntegerArrayList.calculateBitsPerValue(n), 0L, n2);
        this.objectList = new ArrayList(n);
        this.intMap = new HashMap<E, Integer>();
    }

    private int getIntByObject(E e) {
        Integer n = this.intMap.get(e);
        if (n == null) {
            if ((long)this.objectList.size() <= this.packedList.getMaxValue()) {
                this.objectList.add(e);
                n = this.objectList.size() - 1;
                this.intMap.put(e, n);
            } else {
                throw new IndexOutOfBoundsException("There are already " + this.objectList.size() + " different object types registered in this list which is the maximum number of different objects this list can manage. The specified object is not equal to any of these objects and therefore cannot be add.");
            }
        }
        return n;
    }

    private E getObjectByInt(int n) {
        return this.objectList.get(n);
    }

    @Override
    public boolean add(E e) {
        this.packedList.add(this.getIntByObject(e));
        return true;
    }

    @Override
    public void add(int n, E e) {
        this.packedList.add(n, this.getIntByObject(e));
    }

    @Override
    public E get(int n) {
        return this.getObjectByInt((int)this.packedList.get(n));
    }

    @Override
    public E remove(int n) {
        E e = this.get(n);
        this.packedList.remove(n);
        return e;
    }

    @Override
    protected void removeRange(int n, int n2) {
        this.packedList.removeRange(n, n2 - n);
    }

    @Override
    public E set(int n, E e) {
        E e2 = this.get(n);
        this.packedList.set(n, this.getIntByObject(e));
        return e2;
    }

    @Override
    public int size() {
        return (int)this.packedList.size();
    }

    public int getMaxObjectTypeCount() {
        return (int)(this.packedList.getMaxValue() + 1L);
    }
}

