/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.commons.collections;

import info.bioinfweb.commons.Math2;
import java.util.Arrays;

public class PackedIntegerArrayList {
    public static final int MAX_ARRAY_LENGTH = 0x7FFFFFF7;
    public static final int BLOCK_SIZE = 64;
    public static final int BLOCK_BITS = 6;
    public static final int MOD_MASK = 63;
    protected long[] array;
    private long bitsPerValue;
    private long minValue;
    private long maxValue;
    private final long maskRight;
    private final int bpvMinusBlockSize;
    private long size = 0L;

    public PackedIntegerArrayList(int n, long l, long l2) {
        if (n <= 0 || n >= 64) {
            throw new IllegalArgumentException("At least 1 and at most 63 bits per value are allowed to be used.");
        }
        this.bitsPerValue = n;
        this.minValue = l;
        this.maxValue = l + Math2.longPow(2L, n) - 1L;
        if (this.maxValue < this.minValue) {
            throw new IllegalArgumentException("The specified combination of bitsPerValue (" + n + ") and minValue (" + l + ") cannot be represented by a long value.");
        }
        this.array = new long[this.calculateArrayLength(l2)];
        this.maskRight = -1L << 64 - n >>> 64 - n;
        this.bpvMinusBlockSize = n - 64;
    }

    public static int calculateBitsPerValue(int n) {
        int n2 = 1;
        for (int i = 2; i < n; i *= 2) {
            ++n2;
        }
        return n2;
    }

    public long getMinValue() {
        return this.minValue;
    }

    public long getMaxValue() {
        return this.maxValue;
    }

    public long getBitsPerValue() {
        return this.bitsPerValue;
    }

    protected int calculateArrayLength(long l) {
        long l2 = l * this.bitsPerValue;
        long l3 = l2 / 64L;
        if (l2 % 64L > 0L) {
            ++l3;
        }
        if (l3 > 0x7FFFFFF7L) {
            throw new IllegalArgumentException("The value count of " + l + " is to high for " + this.bitsPerValue + " bits per value.");
        }
        return (int)l3;
    }

    public void ensureCapacity(long l) {
        int n = this.calculateArrayLength(l);
        if (n > this.array.length) {
            this.array = Arrays.copyOf(this.array, Math.max(n, Math.min(0x7FFFFFF7, this.array.length * 3 / 2 + 1)));
        }
    }

    protected void insertRange(long l, long l2) {
        if (l2 > 0L) {
            this.ensureCapacity(this.size + l2);
            long l3 = l2 * this.bitsPerValue;
            long l4 = l * this.bitsPerValue;
            long l5 = l3 % 64L;
            long l6 = 64L - l5;
            int n = (int)(l3 / 64L);
            int n2 = (int)(l * this.bitsPerValue / 64L) + n;
            int n3 = Math.min(this.array.length - 1, (int)((this.size + l2) * this.bitsPerValue / 64L));
            long l7 = 64L - l4 % 64L;
            long l8 = this.array[n2] >>> (int)l7 << (int)l7;
            if (l5 == 0L) {
                for (int i = n3; i > n2; --i) {
                    this.array[i] = this.array[i - n];
                }
            } else {
                for (int i = n3; i > n2; --i) {
                    this.array[i] = this.array[i - n] >>> (int)l5 | this.array[i - n - 1] << (int)l6;
                }
            }
            this.array[n2] = this.array[n2 - n] >>> (int)l5;
            if (n == 0 && l7 < 64L) {
                this.array[n2] = this.array[n2] & -1L >>> (int)(64L - l7) | l8;
            }
            this.size += l2;
        }
    }

    protected void removeRange(long l, long l2) {
        if (l < 0L || l + l2 > this.size) {
            throw new IllegalArgumentException("The specified range starting at " + l + " with the length " + l2 + " cannot be removed because it is not completly contained in the current list.");
        }
        if (l2 == this.size) {
            this.size = 0L;
        } else if (l2 > 0L) {
            long l3 = l2 * this.bitsPerValue;
            int n = this.calculateArrayLength(l + 1L) - 1;
            int n2 = this.calculateArrayLength(this.size - l2) - 1;
            int n3 = (int)l3 / 64;
            long l4 = 64L - l * this.bitsPerValue % 64L;
            boolean bl = n >= 0;
            long l5 = 0L;
            if (bl) {
                l5 = this.array[n] >>> (int)l4 << (int)l4;
            }
            long l6 = l3 % 64L;
            long l7 = 64L - l6;
            int n4 = Math.max(0, n);
            if (l6 == 0L) {
                for (int i = n4; i <= n2; ++i) {
                    this.array[i] = this.array[i + n3];
                }
            } else {
                for (int i = n4; i < n2; ++i) {
                    this.array[i] = this.array[i + n3] << (int)l6 | this.array[i + n3 + 1] >>> (int)l7;
                }
                this.array[n2] = this.array[n2 + n3] << (int)l6;
                if (this.array.length > n2 + n3 + 1) {
                    int n5 = n2;
                    this.array[n5] = this.array[n5] | this.array[n2 + n3 + 1] >>> (int)l7;
                }
            }
            if (bl && l4 < 64L) {
                this.array[n] = this.array[n] & -1L >>> (int)(64L - l4) | l5;
            }
            this.size -= l2;
        }
    }

    private void checkIndex(long l, long l2) {
        if (!Math2.isBetween(l, 0L, this.size + l2 - 1L)) {
            throw new IndexOutOfBoundsException("The index " + l + " is out of bounds (" + 0 + ", " + (this.size + l2 - 1L) + ").");
        }
    }

    private void checkValue(long l) {
        if (!Math2.isBetween(l, this.minValue, this.maxValue)) {
            throw new IllegalArgumentException("The specified value " + l + " is not in the element range of this list (" + this.minValue + ", " + this.maxValue + ").");
        }
    }

    public void add(long l, long l2) {
        this.checkIndex(l, 1L);
        this.checkValue(l2);
        this.insertRange(l, 1L);
        this.set(l, l2);
    }

    public void add(long l) {
        this.checkValue(l);
        ++this.size;
        this.ensureCapacity(this.size);
        this.set(this.size - 1L, l);
    }

    public long get(long l) {
        this.checkIndex(l, 0L);
        long l2 = l * this.bitsPerValue;
        int n = (int)(l2 >>> 6);
        long l3 = (l2 & 0x3FL) + (long)this.bpvMinusBlockSize;
        long l4 = l3 <= 0L ? this.array[n] >>> (int)(-l3) & this.maskRight : (this.array[n] << (int)l3 | this.array[n + 1] >>> (int)(64L - l3)) & this.maskRight;
        return l4 + this.minValue;
    }

    public void remove(long l) {
        this.removeRange(l, 1L);
    }

    public void set(long l, long l2) {
        this.checkIndex(l, 0L);
        this.checkValue(l2);
        l2 -= this.minValue;
        long l3 = l * this.bitsPerValue;
        int n = (int)(l3 >>> 6);
        long l4 = (l3 & 0x3FL) + (long)this.bpvMinusBlockSize;
        if (l4 <= 0L) {
            this.array[n] = this.array[n] & (this.maskRight << (int)(-l4) ^ 0xFFFFFFFFFFFFFFFFL) | l2 << (int)(-l4);
        } else {
            this.array[n] = this.array[n] & (this.maskRight >>> (int)l4 ^ 0xFFFFFFFFFFFFFFFFL) | l2 >>> (int)l4;
            this.array[n + 1] = this.array[n + 1] & -1L >>> (int)l4 | l2 << (int)(64L - l4);
        }
    }

    public long size() {
        return this.size;
    }
}

