/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.commons.collections;

import info.bioinfweb.commons.Math2;
import info.bioinfweb.commons.collections.SimpleSequenceInterval;
import info.bioinfweb.commons.collections.SimpleSequenceIntervalFirstPosComparator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;

public class NonOverlappingIntervalList
extends TreeSet<SimpleSequenceInterval> {
    public NonOverlappingIntervalList() {
        super(new SimpleSequenceIntervalFirstPosComparator());
    }

    @Override
    public boolean add(SimpleSequenceInterval simpleSequenceInterval) {
        return this.add(simpleSequenceInterval.getFirstPos(), simpleSequenceInterval.getLastPos());
    }

    @Override
    public boolean add(int n) {
        return this.add(n, n);
    }

    public boolean add(int n, int n2) {
        SortedSet<SimpleSequenceInterval> sortedSet = this.getOverlappingElements(n - 1, n2 + 1);
        if (!sortedSet.isEmpty()) {
            this.removeAll(sortedSet);
            n = Math.min(n, sortedSet.first().getFirstPos());
            n2 = Math.max(n2, sortedSet.last().getLastPos());
        }
        return super.add(new SimpleSequenceInterval(n, n2));
    }

    @Override
    public boolean remove(Object object) {
        boolean bl = super.remove(object);
        if (!bl && object instanceof SimpleSequenceInterval) {
            SimpleSequenceInterval simpleSequenceInterval = (SimpleSequenceInterval)object;
            bl = this.remove(simpleSequenceInterval.getFirstPos(), simpleSequenceInterval.getLastPos());
        }
        return bl;
    }

    public boolean remove(int n, int n2) {
        SortedSet<SimpleSequenceInterval> sortedSet = this.getOverlappingElements(n - 1, n2 + 1);
        if (!sortedSet.isEmpty()) {
            this.removeAll(sortedSet);
            if (sortedSet.first().getFirstPos() < n) {
                super.add(new SimpleSequenceInterval(sortedSet.first().getFirstPos(), n));
            }
            if (n2 < sortedSet.last().getLastPos()) {
                super.add(new SimpleSequenceInterval(n2, sortedSet.last().getLastPos()));
            }
            return true;
        }
        return false;
    }

    public void addAll(NonOverlappingIntervalList nonOverlappingIntervalList, int n, int n2, boolean bl) {
        SortedSet<SimpleSequenceInterval> sortedSet = nonOverlappingIntervalList.getOverlappingElements(n, n2);
        int n3 = bl ? -n : 0;
        for (SimpleSequenceInterval simpleSequenceInterval : sortedSet) {
            this.add(Math.max(n, simpleSequenceInterval.getFirstPos()) + n3, Math.min(n2 - 1, simpleSequenceInterval.getLastPos()) + n3);
        }
    }

    public void addAll(NonOverlappingIntervalList nonOverlappingIntervalList) {
        this.addAll(nonOverlappingIntervalList, 0, ((SimpleSequenceInterval)nonOverlappingIntervalList.last()).getLastPos() + 1, false);
    }

    public void movePositions(int n, int n2) {
        SortedSet<SimpleSequenceInterval> sortedSet = this.tailSet(new SimpleSequenceInterval(n, n));
        ArrayList<SimpleSequenceInterval> arrayList = new ArrayList<SimpleSequenceInterval>(sortedSet.size());
        arrayList.addAll(sortedSet);
        this.removeAll(arrayList);
        for (SimpleSequenceInterval simpleSequenceInterval : arrayList) {
            this.add(simpleSequenceInterval.getFirstPos() + n2, simpleSequenceInterval.getLastPos() + n2);
        }
    }

    public boolean contains(int n) {
        SimpleSequenceInterval simpleSequenceInterval = this.floor(new SimpleSequenceInterval(n, n));
        return simpleSequenceInterval != null && Math2.isBetween(n, simpleSequenceInterval.getFirstPos(), simpleSequenceInterval.getLastPos());
    }

    public boolean containsAll(int n, int n2) {
        SimpleSequenceInterval simpleSequenceInterval = this.floor(new SimpleSequenceInterval(n, n2));
        return simpleSequenceInterval != null && simpleSequenceInterval.getFirstPos() <= n && simpleSequenceInterval.getLastPos() >= n2;
    }

    public SortedSet<SimpleSequenceInterval> getOverlappingElements(int n, int n2) {
        TreeSet<SimpleSequenceInterval> treeSet = new TreeSet<SimpleSequenceInterval>(new SimpleSequenceIntervalFirstPosComparator());
        SimpleSequenceInterval simpleSequenceInterval = new SimpleSequenceInterval(n, n2);
        SimpleSequenceInterval simpleSequenceInterval2 = this.floor(simpleSequenceInterval);
        SortedSet<SimpleSequenceInterval> sortedSet = simpleSequenceInterval2 != null ? this.tailSet(simpleSequenceInterval2) : this;
        Iterator iterator = sortedSet.iterator();
        if (iterator.hasNext()) {
            SimpleSequenceInterval simpleSequenceInterval3;
            do {
                if (!Math2.overlaps(n, n2, (simpleSequenceInterval3 = (SimpleSequenceInterval)iterator.next()).getFirstPos(), simpleSequenceInterval3.getLastPos())) continue;
                treeSet.add(simpleSequenceInterval3);
            } while (iterator.hasNext() && simpleSequenceInterval3.getFirstPos() <= n2);
        }
        return treeSet;
    }
}

