/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.commons.collections;

import info.bioinfweb.commons.collections.ListIteratorDecorator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public abstract class ListDecorator<E>
implements List<E> {
    private List<E> underlyingList;

    public ListDecorator(List<E> list) {
        this.underlyingList = list;
    }

    protected List<E> getUnderlyingList() {
        return this.underlyingList;
    }

    protected void beforeAdd(int n, Collection<? extends E> collection) {
    }

    private void beforeAdd(int n, E e) {
        this.beforeAdd(n, (E)Collections.nCopies(1, e));
    }

    protected void afterAdd(int n, Collection<? extends E> collection) {
    }

    private void afterAdd(int n, E e) {
        this.afterAdd(n, (E)Collections.nCopies(1, e));
    }

    protected void beforeReplace(int n, E e, E e2) {
    }

    protected void afterReplace(int n, E e, E e2) {
    }

    protected void beforeRemove(int n, Collection<Object> collection) {
    }

    private void beforeRemove(int n, Object object) {
        this.beforeRemove(n, Collections.nCopies(1, object));
    }

    protected void afterRemove(int n, Collection<? extends E> collection) {
    }

    private void afterRemove(int n, E e) {
        this.afterRemove(n, (E)Collections.nCopies(1, e));
    }

    protected ListIterator<E> createDecoratedListIterator(ListIterator<E> listIterator) {
        final ListDecorator listDecorator = this;
        return new ListIteratorDecorator<E>(listIterator){

            @Override
            protected void beforeAdd(int n, E e) {
                listDecorator.beforeAdd(n, e);
            }

            @Override
            protected void afterAdd(int n, E e) {
                listDecorator.afterAdd(n, e);
            }

            @Override
            protected void beforeReplace(int n, E e, E e2) {
                listDecorator.beforeReplace(n, e, e2);
            }

            @Override
            protected void afterReplace(int n, E e, E e2) {
                listDecorator.afterReplace(n, e, e2);
            }

            @Override
            protected void beforeRemove(int n, Object object) {
                listDecorator.beforeRemove(n, object);
            }

            @Override
            protected void afterRemove(int n, E e) {
                listDecorator.afterRemove(n, e);
            }
        };
    }

    @Override
    public boolean add(E e) {
        int n = this.size();
        this.beforeAdd(n, e);
        boolean bl = this.underlyingList.add(e);
        if (bl) {
            this.afterAdd(n, e);
        }
        return bl;
    }

    @Override
    public void add(int n, E e) {
        this.beforeAdd(n, e);
        this.underlyingList.add(n, e);
        this.afterAdd(n, e);
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        this.beforeAdd(this.size(), (E)collection);
        boolean bl = this.getUnderlyingList().addAll(collection);
        if (bl) {
            this.afterAdd(this.size() - collection.size(), (E)collection);
        }
        return bl;
    }

    @Override
    public boolean addAll(int n, Collection<? extends E> collection) {
        this.beforeAdd(n, (E)collection);
        boolean bl = this.getUnderlyingList().addAll(n, collection);
        if (bl) {
            this.afterAdd(n, (E)collection);
        }
        return bl;
    }

    @Override
    public void clear() {
        Collection collection = new ArrayList(this.size());
        collection.addAll(this);
        collection = Collections.unmodifiableCollection(collection);
        this.beforeRemove(0, (Object)collection);
        this.getUnderlyingList().clear();
        this.afterRemove(0, (E)collection);
    }

    @Override
    public boolean contains(Object object) {
        return this.underlyingList.contains(object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.underlyingList.containsAll(collection);
    }

    @Override
    public boolean equals(Object object) {
        return this.underlyingList.equals(object);
    }

    @Override
    public E get(int n) {
        return this.underlyingList.get(n);
    }

    @Override
    public int hashCode() {
        return this.underlyingList.hashCode();
    }

    @Override
    public int indexOf(Object object) {
        return this.underlyingList.indexOf(object);
    }

    @Override
    public boolean isEmpty() {
        return this.underlyingList.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        final Iterator<E> iterator = this.getUnderlyingList().iterator();
        return new Iterator<E>(){
            private E currentElement = null;
            private int currentIndex = -1;

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public E next() {
                this.currentElement = iterator.next();
                ++this.currentIndex;
                return this.currentElement;
            }

            @Override
            public void remove() {
                if (this.currentElement == null) {
                    throw new IllegalStateException("The next() method has never been called.");
                }
                ListDecorator.this.beforeRemove(this.currentIndex, this.currentElement);
                iterator.remove();
                ListDecorator.this.afterRemove(this.currentIndex, this.currentElement);
                --this.currentIndex;
            }
        };
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.underlyingList.lastIndexOf(object);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.createDecoratedListIterator(this.underlyingList.listIterator());
    }

    @Override
    public ListIterator<E> listIterator(int n) {
        return this.createDecoratedListIterator(this.underlyingList.listIterator(n));
    }

    @Override
    public E remove(int n) {
        this.beforeRemove(n, this.get(n));
        E e = this.getUnderlyingList().remove(n);
        this.afterRemove(n, e);
        return e;
    }

    @Override
    public boolean remove(Object object) {
        int n = this.indexOf(object);
        if (n != -1) {
            this.remove(this.get(n));
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean bl = false;
        Iterator<?> iterator = collection.iterator();
        if (iterator.hasNext()) {
            boolean bl2 = true;
            Object obj = iterator.next();
            while (bl2) {
                int n = this.indexOf(obj);
                if (n != -1) {
                    ArrayList arrayList = new ArrayList();
                    arrayList.add(obj);
                    bl2 = iterator.hasNext();
                    if (bl2) {
                        int n2 = n + 1;
                        obj = iterator.next();
                        while (bl2 && this.get(n2) == obj) {
                            arrayList.add(obj);
                            bl2 = iterator.hasNext();
                            if (bl2) {
                                obj = iterator.next();
                            }
                            ++n2;
                        }
                    }
                    this.beforeRemove(n, (Object)arrayList);
                    if (!this.getUnderlyingList().removeAll(arrayList)) continue;
                    bl = true;
                    this.afterRemove(n, (E)arrayList);
                    continue;
                }
                obj = iterator.next();
            }
        }
        return bl;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        ArrayList arrayList = new ArrayList(this.size());
        arrayList.addAll(this);
        arrayList.removeAll(collection);
        return this.removeAll(arrayList);
    }

    @Override
    public E set(int n, E e) {
        this.beforeReplace(n, this.get(n), e);
        E e2 = this.getUnderlyingList().set(n, e);
        this.afterReplace(n, e2, e);
        return e2;
    }

    @Override
    public int size() {
        return this.underlyingList.size();
    }

    @Override
    public List<E> subList(final int n, int n2) {
        final ListDecorator listDecorator = this;
        return new ListDecorator<E>(this.getUnderlyingList().subList(n, n2)){

            @Override
            protected void beforeAdd(int n2, Collection<? extends E> collection) {
                listDecorator.beforeAdd(n2 + n, collection);
            }

            @Override
            protected void afterAdd(int n2, Collection<? extends E> collection) {
                listDecorator.afterAdd(n + n2, collection);
            }

            @Override
            protected void beforeReplace(int n2, E e, E e2) {
                listDecorator.beforeReplace(n + n2, e, e2);
            }

            @Override
            protected void afterReplace(int n2, E e, E e2) {
                listDecorator.afterReplace(n + n2, e, e2);
            }

            @Override
            protected void beforeRemove(int n2, Collection<Object> collection) {
                listDecorator.beforeRemove(n + n2, collection);
            }

            @Override
            protected void afterRemove(int n2, Collection<? extends E> collection) {
                listDecorator.afterRemove(n + n2, collection);
            }
        };
    }

    @Override
    public Object[] toArray() {
        return this.underlyingList.toArray();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return this.underlyingList.toArray(TArray);
    }
}

