/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.commons.appversion;

import info.bioinfweb.commons.appversion.AppVersionXMLConstants;
import info.bioinfweb.commons.appversion.ApplicationType;
import info.bioinfweb.commons.appversion.ApplicationVersion;
import info.bioinfweb.commons.io.XMLUtils;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.StartElement;

public class AppVersionXMLReadWrite
extends AppVersionXMLConstants {
    public static void write(XMLStreamWriter xMLStreamWriter, ApplicationVersion applicationVersion) throws XMLStreamException {
        xMLStreamWriter.writeStartElement(TAG_APP_VERSION.toString());
        xMLStreamWriter.writeAttribute(ATTR_MAJOR_APP_VERSION.toString(), "" + applicationVersion.getMajorRelease());
        xMLStreamWriter.writeAttribute(ATTR_MINOR_APP_VERSION.toString(), "" + applicationVersion.getMinorRelease());
        xMLStreamWriter.writeAttribute(ATTR_PATCH_LEVEL.toString(), "" + applicationVersion.getPatchLevel());
        xMLStreamWriter.writeAttribute(ATTR_BUILD_NO.toString(), "" + applicationVersion.getBuildNumber());
        if (!applicationVersion.getType().equals((Object)ApplicationType.STABLE)) {
            xMLStreamWriter.writeAttribute(ATTR_APP_TYPE.toString(), "" + (Object)((Object)applicationVersion.getType()));
        }
        xMLStreamWriter.writeEndElement();
    }

    public static ApplicationVersion read(StartElement startElement) throws XMLStreamException {
        ApplicationVersion applicationVersion = new ApplicationVersion();
        applicationVersion.setMajorRelease(XMLUtils.readIntAttr(startElement, ATTR_MAJOR_APP_VERSION, -1));
        applicationVersion.setMinorRelease(XMLUtils.readIntAttr(startElement, ATTR_MINOR_APP_VERSION, -1));
        applicationVersion.setPatchLevel(XMLUtils.readIntAttr(startElement, ATTR_PATCH_LEVEL, -1));
        applicationVersion.setBuildNumber(XMLUtils.readIntAttr(startElement, ATTR_BUILD_NO, -1));
        ApplicationType applicationType = ApplicationType.parseType(XMLUtils.readStringAttr(startElement, ATTR_APP_TYPE, null));
        if (applicationType != null) {
            applicationVersion.setType(applicationType);
        }
        return applicationVersion;
    }
}

