/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.commons;

import java.awt.Rectangle;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.regex.Pattern;

public class Math2 {
    public static final Pattern INT_PATTERN = Pattern.compile("-?\\d+");

    public static double log(double d, double d2) {
        return Math.log(d) / Math.log(d2);
    }

    public static int intPow(int n, int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("The exponent must be greater or equal to zero (" + n2 + ").");
        }
        int n3 = 1;
        for (int i = 0; i < n2; ++i) {
            n3 *= n;
        }
        return n3;
    }

    public static long longPow(long l, long l2) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("The exponent must be greater or equal to zero (" + l2 + ").");
        }
        long l3 = 1L;
        for (long i = 0L; i < l2; ++i) {
            l3 *= l;
        }
        return l3;
    }

    public static int divAbove(int n, int n2) {
        int n3 = n / n2;
        if (n % n2 > 0) {
            ++n3;
        }
        return n3;
    }

    public static boolean isInt(String string) {
        return INT_PATTERN.matcher(string).matches();
    }

    public static boolean isInt(double d) {
        return d == Math.rint(d) && !Double.isInfinite(d);
    }

    public static boolean isInt(float f) {
        return f == (float)Math.rint(f) && !Float.isInfinite(f);
    }

    public static boolean isDecimal(String string) {
        boolean bl = true;
        try {
            Math2.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        return bl;
    }

    public static int minInt(int ... nArray) {
        if (nArray.length == 1) {
            return nArray[0];
        }
        if (nArray.length >= 2) {
            int n = nArray[0];
            for (int i = 1; i < nArray.length; ++i) {
                n = Math.min(n, nArray[i]);
            }
            return n;
        }
        throw new IllegalArgumentException("This function must have at least two parameters.");
    }

    public static long minLong(long ... lArray) {
        if (lArray.length == 1) {
            return lArray[0];
        }
        if (lArray.length >= 2) {
            long l = lArray[0];
            for (int i = 1; i < lArray.length; ++i) {
                l = Math.min(l, lArray[i]);
            }
            return l;
        }
        throw new IllegalArgumentException("This function must have at least two parameters.");
    }

    public static float minFloat(float ... fArray) {
        if (fArray.length == 1) {
            return fArray[0];
        }
        if (fArray.length >= 2) {
            float f = fArray[0];
            for (int i = 1; i < fArray.length; ++i) {
                f = Math.min(f, fArray[i]);
            }
            return f;
        }
        throw new IllegalArgumentException("This function must have at least two parameters.");
    }

    public static double minDouble(double ... dArray) {
        if (dArray.length == 1) {
            return dArray[0];
        }
        if (dArray.length >= 2) {
            double d = dArray[0];
            for (int i = 1; i < dArray.length; ++i) {
                d = Math.min(d, dArray[i]);
            }
            return d;
        }
        throw new IllegalArgumentException("This function must have at least two parameters.");
    }

    public static int maxInt(int ... nArray) {
        if (nArray.length == 1) {
            return nArray[0];
        }
        if (nArray.length >= 2) {
            int n = nArray[0];
            for (int i = 1; i < nArray.length; ++i) {
                n = Math.max(n, nArray[i]);
            }
            return n;
        }
        throw new IllegalArgumentException("This function must have at least two parameters.");
    }

    public static long maxLong(long ... lArray) {
        if (lArray.length == 1) {
            return lArray[0];
        }
        if (lArray.length >= 2) {
            long l = lArray[0];
            for (int i = 1; i < lArray.length; ++i) {
                l = Math.max(l, lArray[i]);
            }
            return l;
        }
        throw new IllegalArgumentException("This function must have at least two parameters.");
    }

    public static float maxFloat(float ... fArray) {
        if (fArray.length == 1) {
            return fArray[0];
        }
        if (fArray.length >= 2) {
            float f = fArray[0];
            for (int i = 1; i < fArray.length; ++i) {
                f = Math.max(f, fArray[i]);
            }
            return f;
        }
        throw new IllegalArgumentException("This function must have at least two parameters.");
    }

    public static double maxDouble(double ... dArray) {
        if (dArray.length == 1) {
            return dArray[0];
        }
        if (dArray.length >= 2) {
            double d = dArray[0];
            for (int i = 1; i < dArray.length; ++i) {
                d = Math.max(d, dArray[i]);
            }
            return d;
        }
        throw new IllegalArgumentException("This function must have at least two parameters.");
    }

    public static boolean isBetween(byte by, byte by2, byte by3) {
        return by >= by2 && by <= by3;
    }

    public static boolean isBetween(int n, int n2, int n3) {
        return n >= n2 && n <= n3;
    }

    public static boolean isBetween(long l, long l2, long l3) {
        return l >= l2 && l <= l3;
    }

    public static boolean isBetween(float f, float f2, float f3) {
        return f >= f2 && f <= f3;
    }

    public static boolean isBetween(double d, double d2, double d3) {
        return d >= d2 && d <= d3;
    }

    public static boolean isBetweenNE(byte by, byte by2, byte by3) {
        return by > by2 && by < by3;
    }

    public static boolean isBetweenNE(int n, int n2, int n3) {
        return n > n2 && n < n3;
    }

    public static boolean isBetweenNE(long l, long l2, long l3) {
        return l > l2 && l < l3;
    }

    public static boolean isBetweenNE(float f, float f2, float f3) {
        return f > f2 && f < f3;
    }

    public static boolean isBetweenNE(double d, double d2, double d3) {
        return d > d2 && d < d3;
    }

    public static byte moveBetween(byte by, byte by2, byte by3) {
        return (byte)Math.min(by3, Math.max(by2, by));
    }

    public static int moveBetween(int n, int n2, int n3) {
        return Math.min(n3, Math.max(n2, n));
    }

    public static long moveBetween(long l, long l2, long l3) {
        return Math.min(l3, Math.max(l2, l));
    }

    public static float moveBetween(float f, float f2, float f3) {
        return Math.min(f3, Math.max(f2, f));
    }

    public static double moveBetween(double d, double d2, double d3) {
        return Math.min(d3, Math.max(d2, d));
    }

    public static boolean overlaps(byte by, byte by2, byte by3, byte by4) {
        return Math2.isBetween(by, by3, by4) || Math2.isBetween(by2, by3, by4) || Math2.isBetween(by3, by, by2) || Math2.isBetween(by4, by, by2);
    }

    public static boolean overlaps(int n, int n2, int n3, int n4) {
        return Math2.isBetween(n, n3, n4) || Math2.isBetween(n2, n3, n4) || Math2.isBetween(n3, n, n2) || Math2.isBetween(n4, n, n2);
    }

    public static boolean overlaps(long l, long l2, long l3, long l4) {
        return Math2.isBetween(l, l3, l4) || Math2.isBetween(l2, l3, l4) || Math2.isBetween(l3, l, l2) || Math2.isBetween(l4, l, l2);
    }

    public static boolean overlaps(float f, float f2, float f3, float f4) {
        return Math2.isBetween(f, f3, f4) || Math2.isBetween(f2, f3, f4) || Math2.isBetween(f3, f, f2) || Math2.isBetween(f4, f, f2);
    }

    public static boolean overlaps(double d, double d2, double d3, double d4) {
        return Math2.isBetween(d, d3, d4) || Math2.isBetween(d2, d3, d4) || Math2.isBetween(d3, d, d2) || Math2.isBetween(d4, d, d2);
    }

    public static boolean overlapsNE(byte by, byte by2, byte by3, byte by4) {
        return by >= by3 && by < by4 || by2 > by3 && by2 <= by4 || by3 >= by && by3 < by2 || by4 > by && by4 <= by2;
    }

    public static boolean overlapsNE(int n, int n2, int n3, int n4) {
        return n >= n3 && n < n4 || n2 > n3 && n2 <= n4 || n3 >= n && n3 < n2 || n4 > n && n4 <= n2;
    }

    public static boolean overlapsNE(long l, long l2, long l3, long l4) {
        return l >= l3 && l < l4 || l2 > l3 && l2 <= l4 || l3 >= l && l3 < l2 || l4 > l && l4 <= l2;
    }

    public static boolean overlapsNE(float f, float f2, float f3, float f4) {
        return Math2.isBetweenNE(f, f3, f4) || Math2.isBetweenNE(f2, f3, f4) || Math2.isBetweenNE(f3, f, f2) || Math2.isBetweenNE(f4, f, f2);
    }

    public static boolean overlapsNE(double d, double d2, double d3, double d4) {
        return d >= d3 && d < d4 || d2 > d3 && d2 <= d4 || d3 >= d && d3 < d2 || d4 > d && d4 <= d2;
    }

    public static boolean containsRect(Rectangle rectangle, Rectangle rectangle2) {
        int n = rectangle.x - rectangle2.x;
        int n2 = rectangle.y - rectangle2.y;
        return n >= 0 && rectangle.width <= rectangle2.width - n && n2 >= 0 && rectangle.height <= rectangle2.height - n2;
    }

    public static long roundUp(double d) {
        long l = (long)d;
        if ((double)l < d) {
            ++l;
        }
        return l;
    }

    public static int roundUp(float f) {
        int n = (int)f;
        if ((float)n < f) {
            ++n;
        }
        return n;
    }

    public static BigDecimal roundBigDecimal(BigDecimal bigDecimal, RoundingMode roundingMode) {
        return bigDecimal.round(new MathContext(0, roundingMode));
    }

    public static BigDecimal floorBigDecimal(BigDecimal bigDecimal) {
        return Math2.roundBigDecimal(bigDecimal, RoundingMode.FLOOR);
    }

    public static BigInteger roundBigDecimalToBigInteger(BigDecimal bigDecimal, RoundingMode roundingMode) {
        return new BigInteger(Math2.roundBigDecimal(bigDecimal, roundingMode).toString());
    }

    public static BigInteger floorBigDecimalToBigInteger(BigDecimal bigDecimal) {
        return new BigInteger(Math2.roundBigDecimal(bigDecimal, RoundingMode.FLOOR).toString());
    }

    public static double roundSignificantDigit(double d, int n) {
        double d2 = Math.pow(10.0, n);
        double d3 = d % d2;
        d = d - d3 + (double)Math.round(d3 / d2) * d2;
        return d;
    }

    public static float roundSignificantDigit(float f, int n) {
        float f2 = (float)Math.pow(10.0, n);
        float f3 = f % f2;
        f = f - f3 + (float)Math.round(f3 / f2) * f2;
        return f;
    }

    public static double roundFirstSignificantDigit(double d) {
        return Math2.roundSignificantDigit(d, (int)Math.floor(Math.log10(d)));
    }

    public static float roundFirstSignificantDigit(float f) {
        return Math2.roundSignificantDigit(f, (int)Math.floor(Math.log10(f)));
    }

    public static float parseFloat(String string) {
        return Float.parseFloat(string.replace(',', '.'));
    }

    public static double parseDouble(String string) {
        return Double.parseDouble(string.replace(',', '.'));
    }

    public static String decimalToString(double d, int n) {
        if (n > 0) {
            String string = "" + Math.round(d *= Math.pow(10.0, n));
            if (string.equals("0")) {
                string = "0.";
                for (int i = 1; i <= n; ++i) {
                    string = string + "0";
                }
                return string;
            }
            int n2 = string.length() - n;
            if (n2 == 0) {
                return "0." + string;
            }
            return string.substring(0, n2) + "." + string.substring(n2, string.length());
        }
        return "" + Math.round(d);
    }

    public static int sum1ToN(int n) {
        if (n < 0) {
            throw new ArithmeticException("n must be greater of equal to zero (" + n + ")");
        }
        return n * (n + 1) / 2;
    }
}

