/*****************************************************************************
 *
 * Copyright (c) 2008-14, Joachim Fellmuth, Holger Gross, Florian Greiner, 
 * Bettina Hünnemeyer, Paula Herber, Verena Klös, Timm Liebrenz, 
 * Tobias Pfeffer, Marcel Pockrandt, Rolf Schröder
 * Technische Universitaet Berlin, Software Engineering for Embedded
 * Systems Group, Ernst-Reuter-Platz 7, 10587 Berlin, Germany.
 * All rights reserved.
 * 
 * This file is part of STATE (SystemC to Timed Automata Transformation Engine).
 * 
 * STATE is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your
 * option) any later version.
 * 
 * STATE is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with STATE.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 *  Please report any problems or bugs to: state@pes.tu-berlin.de
 *
 ****************************************************************************/

package de.tub.pes.syscir.engine.util;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.Document;
import org.xml.sax.SAXException;

/**
 * Provides functions to ease handling of inputstreams.
 * 
 * @author pockrandt
 * 
 */
public class IOUtil {

	/**
	 * Returns an InputStream for the specified location. This is either done by
	 * using a simple FileInputStream or by using a classLoader (only necessary
	 * if the file is contained in a jar).
	 * 
	 * @param location
	 * @return
	 * @throws FileNotFoundException
	 */
	public static InputStream getInputStream(String location)
			throws FileNotFoundException {
		InputStream is = ClassLoader.getSystemClassLoader()
				.getResourceAsStream(location);
		if (is == null) {
			is = new FileInputStream(location);
		}
		return is;
	}

	/**
	 * this function reads the XML-File
	 * 
	 * @param file
	 *            path to the file
	 * @return the XML-Document
	 * @throws SAXException
	 * @throws IOException
	 * @throws ParserConfigurationException
	 */
	public static Document readXML(String file) throws SAXException,
			IOException, ParserConfigurationException {
		Document d = DocumentBuilderFactory.newInstance().newDocumentBuilder()
				.parse(IOUtil.getInputStream(file));
		return d;
	}
}
