/*****************************************************************************
 *
 * Copyright (c) 2008-14, Joachim Fellmuth, Holger Gross, Florian Greiner, 
 * Bettina Hünnemeyer, Paula Herber, Verena Klös, Timm Liebrenz, 
 * Tobias Pfeffer, Marcel Pockrandt, Rolf Schröder
 * Technische Universitaet Berlin, Software Engineering for Embedded
 * Systems Group, Ernst-Reuter-Platz 7, 10587 Berlin, Germany.
 * All rights reserved.
 * 
 * This file is part of STATE (SystemC to Timed Automata Transformation Engine).
 * 
 * STATE is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your
 * option) any later version.
 * 
 * STATE is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with STATE.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 *  Please report any problems or bugs to: state@pes.tu-berlin.de
 *
 ****************************************************************************/

package de.tub.pes.syscir.engine.typetransformer;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

import javax.xml.parsers.ParserConfigurationException;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

import de.tub.pes.syscir.engine.Engine;
import de.tub.pes.syscir.engine.Environment;
import de.tub.pes.syscir.engine.util.IOUtil;
import de.tub.pes.syscir.sc_model.SCClass;
import de.tub.pes.syscir.sc_model.expressions.Expression;
import de.tub.pes.syscir.sc_model.variables.SCKnownType;

/**
 * 
 * @author Paula Herber
 *
 */
public class TLMDmiTransformer extends AbstractTypeTransformer {

	private static Logger logger = LogManager
			.getLogger(TLMDmiTransformer.class.getName());

	@Override
	public void createType(Environment e) {
		super.createType(e);
		this.name = "tlm_dmi";
	}


	@Override
	public SCKnownType initiateInstance(String instName,
			List<Expression> params, Environment e, boolean stat, boolean cons,
			List<String> other_mods) {

		if (!e.getKnownTypes().containsKey(name)) {
			// create and add tlm_dmi
			// reread implementation description
			try {
				Document doc = IOUtil.readXML(impl);
				// Parsing the implementation file
				Environment temp = Engine.parseImplementation(doc);
				// Edit class information and code
				SCClass tlm_dmi = temp.getClassList().get("tlm_dmi");
				tlm_dmi.setName(name);
				// Integrating the newly parsed environment into the already
				// existing
				e.integrate(temp);

			} catch (SAXException exc) {
				exc.printStackTrace();
			} catch (IOException exc) {
				exc.printStackTrace();
			} catch (ParserConfigurationException exc) {
				exc.printStackTrace();
			}
		}

		// create (now) known type
		SCKnownType kt = super.initiateInstance(instName,
				new LinkedList<Expression>(), e, stat, cons, other_mods);

		return kt;
	}

}
