/*****************************************************************************
 *
 * Copyright (c) 2012, Joachim Fellmuth, Paula Herber, Marcel Pockrandt
 * Technische Universitaet Berlin, Software Engineering for Embedded
 * Systems Group, Ernst-Reuter-Platz 7, 10587 Berlin, Germany.
 * All rights reserved.
 * 
 * This file is part of STATE (SystemC to Timed Automata Transformation Engine).
 * 
 * STATE is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your
 * option) any later version.
 * 
 * STATE is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with STATE.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 *  Please report any problems or bugs to: state@pes.tu-berlin.de
 *
 ****************************************************************************/

package de.tub.pes.syscir.engine.nodetransformer;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Node;

import de.tub.pes.syscir.engine.Environment;
import de.tub.pes.syscir.engine.util.NodeUtil;

/**
 * This transformer only prints an error message that says that it is not
 * allowed to be used. Intended to be assigned to those nodes that represent
 * SystemC constructs which are not supported.
 * 
 * @author Joachim Fellmuth
 * 
 */
public class NotAllowedTransformer extends AbstractNodeTransformer {

	private static Logger logger = LogManager
			.getLogger(NotAllowedTransformer.class.getName());

	public void transformNode(Node node, Environment e) {
		logger.error("{}: This node can not be translated.",
				NodeUtil.getFixedAttributes(node));
	}

}
