/*****************************************************************************
 *
 * Copyright (c) 2008-14, Joachim Fellmuth, Holger Gross, Florian Greiner, 
 * Bettina Hünnemeyer, Paula Herber, Verena Klös, Timm Liebrenz, 
 * Tobias Pfeffer, Marcel Pockrandt, Rolf Schröder
 * Technische Universitaet Berlin, Software Engineering for Embedded
 * Systems Group, Ernst-Reuter-Platz 7, 10587 Berlin, Germany.
 * All rights reserved.
 * 
 * This file is part of STATE (SystemC to Timed Automata Transformation Engine).
 * 
 * STATE is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your
 * option) any later version.
 * 
 * STATE is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with STATE.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 *  Please report any problems or bugs to: state@pes.tu-berlin.de
 *
 ****************************************************************************/

package de.tub.pes.sc2uppaal.tamodel.expressions;

import org.w3c.dom.Node;

import de.tub.pes.sc2uppaal.tamodel.TAVariable;
import de.tub.pes.syscir.sc_model.expressions.BinaryExpression;
import de.tub.pes.syscir.sc_model.expressions.ConstantExpression;
import de.tub.pes.syscir.sc_model.expressions.Expression;

/**
 * This expression represents a binary expression of the form:
 * tavarexpr = newvalueexpr;
 * @author rschroeder
 *
 */
public class TAVariableAssignmentExpression extends BinaryExpression {

	private static final long serialVersionUID = -3038233799850168158L;
	
	public TAVariableAssignmentExpression(Node n, TAVariable tavar, Expression right) {
		super(n, new TAVariableExpression(null, tavar), "=", right);
	}

	public TAVariableAssignmentExpression(Node n, TAVariable tavar, String right) {
		this(n, tavar, new ConstantExpression(null, right));
	}

	public TAVariable getTAVar() {
		return ((TAVariableExpression) getLeft()).getVar();
	}
}
