/*****************************************************************************
 *
 * Copyright (c) 2008-14, Joachim Fellmuth, Holger Gross, Florian Greiner, 
 * Bettina Hünnemeyer, Paula Herber, Verena Klös, Timm Liebrenz, 
 * Tobias Pfeffer, Marcel Pockrandt, Rolf Schröder
 * Technische Universitaet Berlin, Software Engineering for Embedded
 * Systems Group, Ernst-Reuter-Platz 7, 10587 Berlin, Germany.
 * All rights reserved.
 * 
 * This file is part of STATE (SystemC to Timed Automata Transformation Engine).
 * 
 * STATE is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your
 * option) any later version.
 * 
 * STATE is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with STATE.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 *  Please report any problems or bugs to: state@pes.tu-berlin.de
 *
 ****************************************************************************/

package de.tub.pes.sc2uppaal.tamodel.expressions;

import java.util.LinkedList;
import java.util.List;

import org.w3c.dom.Node;

import de.tub.pes.sc2uppaal.tamodel.TAVariable;
import de.tub.pes.syscir.engine.util.Pair;
import de.tub.pes.syscir.sc_model.expressions.Expression;

/**
 * Represents either a sync expression like "chanName!" or "chanName?" to sync
 * TAs.
 * 
 * @author rschroeder
 * 
 */

public abstract class TASendRecvExpression extends Expression {

	private static final long serialVersionUID = -7283560718886439929L;
	private final String chanName;
	private final boolean isSend;

	public TASendRecvExpression(Node n, String chanName, boolean isSend) {
		super(n);
		this.chanName = chanName;
		this.isSend = isSend;
	}

	public boolean isSend() {
		return isSend;
	}

	public boolean isRecv() {
		return !isSend();
	}

	/**
	 * This method was formally used to check if a variable is used in this
	 * expression. Obviously, any variable's name that is also used in other
	 * names will be contained and therefore return true.
	 * 
	 * @param var
	 * @return
	 */
	public boolean contains(TAVariable var) {
		return chanName.contains(var.getName());
	}

	public boolean isChanName(String name) {
		return chanName.replaceAll("\\[.*\\]", "").equals(name);
	}

	public String getChanName() {
		return chanName;
	}

	@Override
	public String toString() {
		return chanName + (isSend() ? "!" : "?");
	}

	@Override
	public LinkedList<Expression> crawlDeeper() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public void replaceInnerExpressions(
			List<Pair<Expression, Expression>> replacements) {
		// TODO Auto-generated method stub
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = super.hashCode();
		result = prime * result
				+ ((chanName == null) ? 0 : chanName.hashCode());
		result = prime * result + (isSend ? 1231 : 1237);
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (!super.equals(obj))
			return false;
		if (getClass() != obj.getClass())
			return false;
		TASendRecvExpression other = (TASendRecvExpression) obj;
		if (chanName == null) {
			if (other.chanName != null)
				return false;
		} else if (!chanName.equals(other.chanName))
			return false;
		if (isSend != other.isSend)
			return false;
		return true;
	}
}
