/*****************************************************************************
 *
 * Copyright (c) 2008-14, Joachim Fellmuth, Holger Gross, Florian Greiner, 
 * Bettina Hünnemeyer, Paula Herber, Verena Klös, Timm Liebrenz, 
 * Tobias Pfeffer, Marcel Pockrandt, Rolf Schröder
 * Technische Universitaet Berlin, Software Engineering for Embedded
 * Systems Group, Ernst-Reuter-Platz 7, 10587 Berlin, Germany.
 * All rights reserved.
 * 
 * This file is part of STATE (SystemC to Timed Automata Transformation Engine).
 * 
 * STATE is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your
 * option) any later version.
 * 
 * STATE is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with STATE.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 *  Please report any problems or bugs to: state@pes.tu-berlin.de
 *
 ****************************************************************************/

package de.tub.pes.sc2uppaal.tamodel;

import de.tub.pes.sc2uppaal.tamodel.expressions.TAVariableExpression;
import de.tub.pes.syscir.sc_model.expressions.BinaryExpression;
import de.tub.pes.syscir.sc_model.expressions.ConstantExpression;
import de.tub.pes.syscir.sc_model.expressions.Expression;

/**
 * This type represents selfmade type.
 * Ex:
 * TAVar v = new TAGenericTypeVariable("name", "myType");
 * v.getDeclarationString() == "myType name;"
 * PLEASE USE THIS TYPE ONLY IF YOU HAVE NO OTHER POSSIBILITIES!
 * @author rschroeder
 *
 */
public class TAGenericTypeVariable extends TAVariable {
	
	public TAGenericTypeVariable(String name, String type) {
		this(name, type, null);		
	}
	
	public TAGenericTypeVariable(String name, String type, Expression init) {
		super(name, type, init);
	}

	@Override
	public String getDummyName(TAModel ta) {
		return null;
	}

	@Override
	public TAVariable createCopy(String prefix) {
		TAGenericTypeVariable clone = new TAGenericTypeVariable(prefix + name, type);
		copyAttributesExceptName(clone);
		return clone;
	}
	
	@Override
	public Expression getResetExpr() {
		if (initValue != null) {
			return new BinaryExpression(null, new TAVariableExpression(null, this), "=", initValue);
		} else {
			return new BinaryExpression(null, new TAVariableExpression(null, this), "=", new ConstantExpression(null, Constants.getDefaultValueName(type)));
		}
	}
}

