/*****************************************************************************
 *
 * Copyright (c) 2008-14, Joachim Fellmuth, Holger Gross, Florian Greiner, 
 * Bettina Hünnemeyer, Paula Herber, Verena Klös, Timm Liebrenz, 
 * Tobias Pfeffer, Marcel Pockrandt, Rolf Schröder
 * Technische Universitaet Berlin, Software Engineering for Embedded
 * Systems Group, Ernst-Reuter-Platz 7, 10587 Berlin, Germany.
 * All rights reserved.
 * 
 * This file is part of STATE (SystemC to Timed Automata Transformation Engine).
 * 
 * STATE is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your
 * option) any later version.
 * 
 * STATE is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with STATE.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 *  Please report any problems or bugs to: state@pes.tu-berlin.de
 *
 ****************************************************************************/

package de.tub.pes.sc2uppaal.tamodel;

import de.tub.pes.sc2uppaal.tamodel.expressions.TAVariableAssignmentExpression;
import de.tub.pes.syscir.sc_model.expressions.Expression;

/**
 * Represents variables of the Uppaal clock type.
 * 
 * @author Joachim Fellmuth, Paula Herber
 * 
 * 
 */
public class TAClock extends TAVariable {

	/**
	 * @param name
	 */
	public TAClock(String name) {
		super(name, "clock");
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.tub.pes.state.model.TAVariable#createCopy(java.lang.String)
	 */
	public TAVariable createCopy(String prefix) {
		return new TAClock(prefix + name);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (obj instanceof TAClock) {
			return ((TAClock) obj).getName().equals(name);
		}
		return false;
	}

	@Override
	public int hashCode() {
		int result = 17;
		result = 31 * result + name.hashCode();
		return result;
	}

	@Override
	public String createDeclarationString() {
		return "clock " + name + ";\n";
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * de.tub.pes.state.model.TAVariable#getDummyName(de.tub.pes.state.model
	 * .TAModel)
	 */
	public String getDummyName(TAModel ta) {
		return Constants.DUMMY_CLOCK;
	}

	@Override
	public Expression getResetExpr() {
		Expression expr = new TAVariableAssignmentExpression(null, this, "0");
		return expr;
	}

}
