/*****************************************************************************
 *
 * Copyright (c) 2008-14, Joachim Fellmuth, Holger Gross, Florian Greiner, 
 * Bettina Hünnemeyer, Paula Herber, Verena Klös, Timm Liebrenz, 
 * Tobias Pfeffer, Marcel Pockrandt, Rolf Schröder
 * Technische Universitaet Berlin, Software Engineering for Embedded
 * Systems Group, Ernst-Reuter-Platz 7, 10587 Berlin, Germany.
 * All rights reserved.
 * 
 * This file is part of STATE (SystemC to Timed Automata Transformation Engine).
 * 
 * STATE is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your
 * option) any later version.
 * 
 * STATE is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with STATE.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 *  Please report any problems or bugs to: state@pes.tu-berlin.de
 *
 ****************************************************************************/

package de.tub.pes.sc2uppaal.tamodel;

import java.io.IOException;
import java.io.OutputStreamWriter;

import de.tub.pes.sc2uppaal.util.XMLWriter;

/**
 * @author Joachim Fellmuth, Paula Herber, rschroeder
 * 
 *         Internal representation of an UPPAAL channel variable.
 */
public class TAChannel extends TAVariable {

	/**
	 * Broadcast flag. True if it is a broadcast channel.
	 */
	private boolean broadcast;

	/**
	 * Creates a regular channel with name "name". Binary channel with
	 * broadcast=false, broadcast channel if broadcast=true.
	 * 
	 * @param name
	 * @param broadcast
	 */
	protected TAChannel(String name, boolean broadcast) {
		super(name, "chan");
		this.broadcast = broadcast;
	}

	public TAChannel(String name) {
		this(name, false);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.tub.pes.state.model.TAVariable#createCopy(java.lang.String)
	 */
	public TAVariable createCopy(String prefix) {
		return new TAChannel(prefix + this.name, this.broadcast);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.tub.pes.state.model.TAVariable#print(java.io.OutputStreamWriter)
	 */
	public void print(OutputStreamWriter writer) throws IOException {
		String out = createDeclarationString();
		writer.write(out);
	}

	@Override
	public void printAsParam(XMLWriter writer) throws IOException {
		writer.writeText((broadcast ? "broadcast " : ""));
		super.printAsParam(writer);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * de.tub.pes.state.model.TAVariable#getDummyName(de.tub.pes.state.model
	 * .TAModel)
	 */
	public String getDummyName(TAModel ta) {
		if (broadcast) {
			return Constants.DUMMY_BROADCAST_CHANNEL;
		} else {
			return Constants.DUMMY_CHANNEL;
		}
	}

	@Override
	public String createDeclarationString() {
		return (broadcast ? "broadcast " : "") + "chan " + name + ";\n";
	}

	// public TAArray asArray(int size) {
	// TAArray varAsArray = new TAArray(this.getName(),"chan","1",true,false);
	// varAsArray.addSizeOfDimension(new
	// ConstantExpression(Integer.toString(size)),0);
	// //
	// System.out.println("WARNING: currently, variables converted to arrays are NOT initialized.");
	// return varAsArray;
	// }

	@Override
	public int hashCode() {
		int result = 17;
		result = 31 * result + name.hashCode();
		result = 31 * result + (broadcast ? 1 : 0);
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (obj == null)
			return true;
		if (!(obj instanceof TAChannel))
			return false;
		TAChannel tac = (TAChannel) obj;
		return this.name.equals(tac.getName())
				&& this.broadcast == tac.broadcast;
	}

}
