/*****************************************************************************
 *
 * Copyright (c) 2008-14, Joachim Fellmuth, Holger Gross, Florian Greiner, 
 * Bettina Hünnemeyer, Paula Herber, Verena Klös, Timm Liebrenz, 
 * Tobias Pfeffer, Marcel Pockrandt, Rolf Schröder
 * Technische Universitaet Berlin, Software Engineering for Embedded
 * Systems Group, Ernst-Reuter-Platz 7, 10587 Berlin, Germany.
 * All rights reserved.
 * 
 * This file is part of STATE (SystemC to Timed Automata Transformation Engine).
 * 
 * STATE is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your
 * option) any later version.
 * 
 * STATE is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with STATE.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 *  Please report any problems or bugs to: state@pes.tu-berlin.de
 *
 ****************************************************************************/

package de.tub.pes.sc2uppaal.tamodel;

import java.io.IOException;

import de.tub.pes.sc2uppaal.tamodel.expressions.TAVariableAssignmentExpression;
import de.tub.pes.sc2uppaal.util.XMLWriter;
import de.tub.pes.syscir.sc_model.expressions.ConstantExpression;
import de.tub.pes.syscir.sc_model.expressions.Expression;

/**
 * An AddressPointer is use to refer to the memory model. It's a bounded integer
 * between NULL and sizeOfMem(type). The belonging typedef get's generated with
 * the mem arrays.
 * 
 * @author rschroeder
 * 
 */
public class TAAddressPointer extends TAVariable {
	// TODO: extend from TAGenericTypeVariable
	private static final String SUFFIX = "_addr_ptr";

	public TAAddressPointer(String name, String type) {
		super(name, type, new ConstantExpression(null, Constants.NULL));
	}

	@Override
	public String getType() {
		return typeAsAddrPtr(type);
	}

	@Override
	public String getDummyName(TAModel ta) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public void print(XMLWriter writer) throws IOException {
		String out = createDeclarationString();
		writer.writeText(out);
	}

	@Override
	public Expression getResetExpr() {
		Expression expr = new TAVariableAssignmentExpression(null, this,
				initValue);
		return expr;
	}

	@Override
	public TAVariable createCopy(String prefix) {
		TAVariable clone = new TAAddressPointer(prefix + this.name, this.type);
		return clone;
	}

	public String getMemType() {
		return this.type;
	}

	public static String typeAsAddrPtr(String type) {
		return type + SUFFIX;
	}
}
