/*****************************************************************************
 *
 * Copyright (c) 2008-14, Joachim Fellmuth, Holger Gross, Florian Greiner, 
 * Bettina Hünnemeyer, Paula Herber, Verena Klös, Timm Liebrenz, 
 * Tobias Pfeffer, Marcel Pockrandt, Rolf Schröder
 * Technische Universitaet Berlin, Software Engineering for Embedded
 * Systems Group, Ernst-Reuter-Platz 7, 10587 Berlin, Germany.
 * All rights reserved.
 * 
 * This file is part of STATE (SystemC to Timed Automata Transformation Engine).
 * 
 * STATE is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your
 * option) any later version.
 * 
 * STATE is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with STATE.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 *  Please report any problems or bugs to: state@pes.tu-berlin.de
 *
 ****************************************************************************/

package de.tub.pes.sc2uppaal.tamodel;

/**
 * 
 * @author Joachim Fellmuth
 *
 */

public class SCConstants {
	public static final String SC_ZERO_TIME = "SC_ZERO_TIME";
	

	
		
	/**
	 * Creates an integer representation of the sc_time arguments given as parameters.
	 * <p>
	 * The problem here is that systemC uses different units and double values to represent time, which gives 
	 * it a much greater range than the integer clocks of Uppaal. A useful solution for that
	 * has yet to be found. This is just a dummy representation, which returns the value in nanoseconds (SC_NS). 
	 * pico and femto seconds are not supported, they will be rounded to one ns.   
	 *  
	 * 
	 * @param time 
	 * @param unit A String of the SystemC's sc_time_unit enumeration
	 * @return
	 *
	 */
	public static int getTimeUnits(String time,  String unit) {
		// TODO: create a time units representation that makes sense and does not look stupid
		double units = Integer.parseInt(time);
		double val = 0;
		if(units == 0) return 0;
		
		if(unit.equals("SC_FS")) {
			if((val = (units / 1000000)/Constants.SC_TIME_RESOLUTION) ==0) val = 1;
		} else if(unit.equals("SC_PS")) {
			if((val = (units / 1000)/Constants.SC_TIME_RESOLUTION) ==0) val = 1;
		} else if(unit.equals("SC_NS")) {
			if((val = units/Constants.SC_TIME_RESOLUTION) == 0) val = 1;
		} else if(unit.equals("SC_US")) {
			val = units*1000/Constants.SC_TIME_RESOLUTION ; 
		} else if(unit.equals("SC_MS")) {
			val = units * 1000000/Constants.SC_TIME_RESOLUTION;
		} else { // SC_SEC
			val = units * 1000000000/Constants.SC_TIME_RESOLUTION;
		}
		if(val > Integer.MAX_VALUE) val = Integer.MAX_VALUE;
		return (int) val;
	}
	
	/**
	 * Returns the factor of the given time unit String relative to SC_NS (nanoseconds). 
	 * 
	 * @param str
	 * @return
	 */
	public static int getTimeFactor(String str) {
		if(str.equals("SC_US")) {
			return 1000;
		} else if(str.equals("SC_MS")) {
			return 1000000;
		} else if(str.equals("SC_SEC")) {
			return 1000000000;
		}
		
		return 1;
	}
	
}
