/*****************************************************************************
 *
 * Copyright (c) 2008-14, Joachim Fellmuth, Holger Gross, Florian Greiner, 
 * Bettina Hünnemeyer, Paula Herber, Verena Klös, Timm Liebrenz, 
 * Tobias Pfeffer, Marcel Pockrandt, Rolf Schröder
 * Technische Universitaet Berlin, Software Engineering for Embedded
 * Systems Group, Ernst-Reuter-Platz 7, 10587 Berlin, Germany.
 * All rights reserved.
 * 
 * This file is part of STATE (SystemC to Timed Automata Transformation Engine).
 * 
 * STATE is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your
 * option) any later version.
 * 
 * STATE is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with STATE.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 *  Please report any problems or bugs to: state@pes.tu-berlin.de
 *
 ****************************************************************************/

package de.tub.pes.sc2uppaal.optimization;

import java.util.LinkedList;
import java.util.List;

public class UpdateRequestsDeterminism {
	
	/**
	 * 
	 */
	private List<String> updateRequests;
	
	public UpdateRequestsDeterminism(){
		setUpdateRequests(new LinkedList<String>());
	}
	
	public boolean contains(String name){
		for(String uR : updateRequests){
			if(uR.equals(name)){
				return true;
			}
		}
		return false;
	}

	public int getPos(String name){
		for(int i=0; i<updateRequests.size(); i++){
			if(updateRequests.get(i).equals(name)){
				return i;
			}
		}
		return -1;
	}

	public String getGlobalVariables(){
		
		StringBuilder ret = new StringBuilder();
		if(updateRequests.size()>0){
			
			ret.append("//////////////////////////////\n");
			ret.append("///Request Update Determinism\n");
			ret.append("//////////////////////////////\n");
			
			ret.append("const int UPDATEREQUESTS="+updateRequests.size()+";\n\n");
			ret.append("meta bool enabled_ur[UPDATEREQUESTS]={");
			for(int i=0;i<updateRequests.size();i++){
				ret.append("false");
				if(i!=updateRequests.size()-1){
					ret.append(",");
				}
			}
			ret.append("};\n\n");
			ret.append("meta bool runnable_ur[UPDATEREQUESTS]={");
			for(int i=0;i<updateRequests.size();i++){
				ret.append("false");
				if(i!=updateRequests.size()-1){
					ret.append(",");
				}
			}
			ret.append("};\n\n");
			ret.append("meta int ur;\n\n");
			ret.append("meta bool ur_bool;\n\n");
			
		}
		return ret.toString();
	}

	public String getGlobalFunctionDefinitions() {
		StringBuilder ret = new StringBuilder();
		if(updateRequests.size()>0){

			ret.append("	void recompute_enabled_ur() {\n\n");
			ret.append("		ur_bool=false;\n\n");
			ret.append(" 		for(ur=0; ur<UPDATEREQUESTS; ur++){\n\n");
			ret.append(" 			enabled_ur[ur]=false;\n\n");
			ret.append(" 		}\n\n");
			ret.append(" 		for(ur=0; ur<UPDATEREQUESTS && ur_bool==false; ur++){\n\n");
			ret.append(" 			if(runnable_ur[ur]==true){\n\n");
			ret.append(" 				enabled_ur[ur]=true;\n\n");
			ret.append(" 				ur_bool=true;\n\n");
			ret.append(" 			}\n\n");
			ret.append(" 		}\n\n");
			ret.append(" 	}\n\n");
			
		}
		return ret.toString();
	}

	public List<String> getUpdateRequests() {
		return updateRequests;
	}

	public void setUpdateRequests(List<String> updateRequests) {
		this.updateRequests = updateRequests;
	}

}
