/*****************************************************************************
 *
 * Copyright (c) 2008-14, Joachim Fellmuth, Holger Gross, Florian Greiner, 
 * Bettina Hünnemeyer, Paula Herber, Verena Klös, Timm Liebrenz, 
 * Tobias Pfeffer, Marcel Pockrandt, Rolf Schröder
 * Technische Universitaet Berlin, Software Engineering for Embedded
 * Systems Group, Ernst-Reuter-Platz 7, 10587 Berlin, Germany.
 * All rights reserved.
 * 
 * This file is part of STATE (SystemC to Timed Automata Transformation Engine).
 * 
 * STATE is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your
 * option) any later version.
 * 
 * STATE is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with STATE.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 *  Please report any problems or bugs to: state@pes.tu-berlin.de
 *
 ****************************************************************************/

package de.tub.pes.sc2uppaal.optimization;

import java.util.LinkedList;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import de.tub.pes.sc2uppaal.tamodel.TAModel;
import de.tub.pes.sc2uppaal.tamodel.TATemplate;
import de.tub.pes.sc2uppaal.tamodel.TAVariable;

/**
 * 
 * @author Joachim Fellmuth
 * 
 */

public class TemplateParamsOptimizer implements Optimizer {

	private static Logger logger = LogManager
			.getLogger(TemplateParamsOptimizer.class.getName());

	@Override
	public void run(TAModel ta) {
		int paramCount = 0;
		for (String templateName : ta.getTemplates().keySet()) {
			TATemplate template = ta.getTemplates().get(templateName);
			LinkedList<TAVariable> removableParams = new LinkedList<TAVariable>();

			for (TAVariable var : template.getParameters()) {
				if (!template.isVarUsedInTemplate(var)) {
					removableParams.add(var);
				}
			}
			template.removeParameters(removableParams);
			if(paramCount > 0)
				logger.info(
					"Optimization statistics: Deleted {} template parameters from Template " + template.getName() + ".",
					paramCount);
		}
	}

}
