/*****************************************************************************
 *
 * Copyright (c) 2008-14, Joachim Fellmuth, Holger Gross, Florian Greiner, 
 * Bettina Hünnemeyer, Paula Herber, Verena Klös, Timm Liebrenz, 
 * Tobias Pfeffer, Marcel Pockrandt, Rolf Schröder
 * Technische Universitaet Berlin, Software Engineering for Embedded
 * Systems Group, Ernst-Reuter-Platz 7, 10587 Berlin, Germany.
 * All rights reserved.
 * 
 * This file is part of STATE (SystemC to Timed Automata Transformation Engine).
 * 
 * STATE is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your
 * option) any later version.
 * 
 * STATE is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with STATE.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 *  Please report any problems or bugs to: state@pes.tu-berlin.de
 *
 ****************************************************************************/

package de.tub.pes.sc2uppaal.optimization;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

import de.tub.pes.sc2uppaal.tamodel.TAModel;
import de.tub.pes.sc2uppaal.tamodel.TAVariable;

/**
 * 
 * @author Joachim Fellmuth
 * 
 */

public class SortedOutputOptimizer implements Optimizer {

	public void run(TAModel ta) {
		sortDeclaration(ta);
		// ta.getSystemDeclaration().keySet().
	}

	private void sortDeclaration(TAModel ta) {
		List<TAVariable> oldDecl = ta.getDeclaration();
		LinkedList<TAVariable> prefixDecl = new LinkedList<TAVariable>();
		LinkedList<TAVariable> postfixDecl = new LinkedList<TAVariable>();

		// move all variables containing a keyword from the list to the end of the declaration
		//param, ctrl, peq, wait, notify, sensitive, return
		LinkedList<String> keywords = new LinkedList<String>(Arrays.asList("dummy","param", "ctrl","return", "peq","wait","notify","sensitive"));
		for (TAVariable var : oldDecl) {
			boolean moveToEnd = false;
			for (String keyword : keywords)
			{
				if(var.getName().contains(keyword))
					{
						moveToEnd = true;
					}	
			}
			if (moveToEnd)
				postfixDecl.add(var);	
			else
				prefixDecl.add(var);
		}	
			
		prefixDecl.addAll(postfixDecl);
		
		ta.setDeclaration(prefixDecl);
	}

}
