/*****************************************************************************
 *
 * Copyright (c) 2008-14, Joachim Fellmuth, Holger Gross, Florian Greiner, 
 * Bettina Hünnemeyer, Paula Herber, Verena Klös, Timm Liebrenz, 
 * Tobias Pfeffer, Marcel Pockrandt, Rolf Schröder
 * Technische Universitaet Berlin, Software Engineering for Embedded
 * Systems Group, Ernst-Reuter-Platz 7, 10587 Berlin, Germany.
 * All rights reserved.
 * 
 * This file is part of STATE (SystemC to Timed Automata Transformation Engine).
 * 
 * STATE is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your
 * option) any later version.
 * 
 * STATE is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with STATE.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 *  Please report any problems or bugs to: state@pes.tu-berlin.de
 *
 ****************************************************************************/

package de.tub.pes.sc2uppaal.engine;

import java.util.LinkedList;
import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import de.tub.pes.syscir.engine.modeltransformer.ModelTransformer;
import de.tub.pes.syscir.engine.util.Pair;
import de.tub.pes.syscir.sc_model.SCClass;
import de.tub.pes.syscir.sc_model.SCFunction;
import de.tub.pes.syscir.sc_model.SCProcess;
import de.tub.pes.syscir.sc_model.SCSystem;
import de.tub.pes.syscir.sc_model.expressions.Expression;
import de.tub.pes.syscir.sc_model.expressions.SCVariableDeclarationExpression;

/**
 * 
 * @author rschroeder
 * 
 */
public class VariDeclWithMemModelTransformer implements ModelTransformer {
	private static Logger logger = LogManager
			.getLogger(VariDeclWithMemModelTransformer.class.getName());

	@Override
	public SCSystem transformModel(SCSystem model) {
		List<SCFunction> globfunc = model.getGlobalFunctions();
		List<SCClass> classes = model.getClasses();
		List<Pair<Expression, Expression>> replacements = null;

		for (SCFunction func : globfunc) {
			replacements = getVDReplaceList(func);
			func.replaceExpressions(replacements);
		}

		for (SCClass mod : classes) {
			List<SCFunction> memFunc = mod.getMemberFunctions();
			List<SCProcess> processes = mod.getProcesses();

			for (SCFunction func : memFunc) {
				replacements = getVDReplaceList(func);
				func.replaceExpressions(replacements);
				replacements = getVDReplaceList(func);
				func.replaceExpressions(replacements);
			}
			for (SCProcess proc : processes) {
				SCFunction func = proc.getFunction();
				replacements = getVDReplaceList(func);
				func.replaceExpressions(replacements);
			}

		}

		return model;
	}

	private List<Pair<Expression, Expression>> getVDReplaceList(SCFunction func) {
		List<Pair<Expression, Expression>> replacements = new LinkedList<Pair<Expression, Expression>>();
		Expression replacement = null;
		for (Expression expr : func.getAllExpressions()) {
			if (expr instanceof SCVariableDeclarationExpression) {
				replacement = getReplFromSCVarDeclExpr(
						(SCVariableDeclarationExpression) expr, func);
			}
			if (replacement != null) {
				replacements.add(new Pair<Expression, Expression>(expr,
						replacement));
				replacement = null;
			}
		}
		return replacements;
	}

	private Expression getReplFromSCVarDeclExpr(
			SCVariableDeclarationExpression vdexpr, SCFunction func) {
		Expression replacement = null;
		// SCVariable scVar = null;
		// String valueAsString = null;
		// SCVariable rvalueVar = null;
		// Expression rValueExpr = null;
		// String rVarName = null;
		// SCParameter tmpPar = null;
		// if (!(vdexpr.getVariable() instanceof SCClassInstanceExpression)) {
		// scVar= ((SCVariableExpression) vdexpr.getVariable()).getVar();
		// // TODO:
		// logger.debug("TODO: check if vdexpr.getVariable() is really a scvarexpr");
		// valueAsString = "";
		// rValueExpr = vdexpr.getFirstInitialValue(); // returns null if scvar
		// not initialized
		// if (rValueExpr == null) {
		// if (scVar instanceof SCPointer) {
		// valueAsString = "NULL";
		// }
		// }
		// if (rValueExpr instanceof ConstantExpression) {
		// valueAsString = ((ConstantExpression) rValueExpr).getValue();
		// } else if (rValueExpr instanceof ArrayInitializerExpression) {
		// valueAsString = ((ArrayInitializerExpression)
		// rValueExpr).toStringNoSem();
		// } else if (rValueExpr instanceof SCVariableExpression) {
		// rVarName = ((SCVariableExpression) rValueExpr).getVar().getName();
		// rvalueVar = func.getLocalVariable(rVarName);
		// if (rvalueVar != null) {
		// valueAsString = VariableConverter.derefAddrPtr(rvalueVar.getType(),
		// ((SCVariable) rvalueVar).getName());
		// } else {
		// tmpPar = func.getParameter(rVarName);
		// if (tmpPar != null) {
		// valueAsString =
		// VariableConverter.derefAddrPtr(tmpPar.getVar().getType(),
		// VariableConverter.getAddrPtrNameFor(tmpPar));
		// }
		// }
		// }
		// replacement =
		// TAMemoryType.getAllocationExpressionForLocVar(VariableConverter.getAddrPtrFor(scVar),
		// scVar, valueAsString);
		// } else {
		// // handle sclassinstance
		// }
		return replacement;
	}

}
