#include <systemc.h>

SC_MODULE(outputmon){

  sc_fifo_in<int> p_vl; 
  sc_fifo_in<int> p_vr; 
  sc_fifo_in<int> p_hl;
  sc_fifo_in<int> p_hr;
  
  void monitor_vl(){
      int p; 
	int last_p;
      while(true){
	p = p_vl.read();
	if(p != last_p)
	  cout << sc_time_stamp() << " pressure at left front wheel: " << p << endl; 
	last_p = p;
      }
  }

  void monitor_vr(){
      int p;
      int last_p;
      while(true){
	p = p_vr.read();
	if(p != last_p)
	  cout << sc_time_stamp() << " pressure at right front wheel: " << p << endl; 
	last_p = p;
      }
  }

  void monitor_hl(){
      int p;
    int last_p;
      while(true){
	p = p_hl.read();
	if(p != last_p)
	  cout << sc_time_stamp() << " pressure at left rear wheel: " << p << endl; 
	last_p = p;
      }
  }

  void monitor_hr(){
      int p;
int last_p;
      while(true){
	p =  p_hr.read();
	if(p != last_p)
	  cout << sc_time_stamp() << " pressure at right rear wheel: " << p << endl; 
	last_p = p;
      }
  }


  SC_CTOR(outputmon){
      SC_THREAD(monitor_vl);
      SC_THREAD(monitor_vr);
      SC_THREAD(monitor_hl);
      SC_THREAD(monitor_hr);
  }
  
};


