#include <systemc.h>
#define LOOPCNT 20

SC_MODULE ( inputgen )
{

  sc_out<bool> inTicks_vl;
  sc_out<bool> inTicks_vr;
  sc_out<bool> inTicks_hl;
  sc_out<bool> inTicks_hr; 

  void generate()
    {
      
      bool sw = false;
     
      wait(1, SC_SEC);

      for(int i = 0; i < LOOPCNT; i = i + 1) //  ca 7 sec 
	{
	  wait(6800, SC_US); // -> 200 km/h
	  inTicks_vl.write(sw);
	  inTicks_vr.write(sw);
	  inTicks_hl.write(sw);
	  inTicks_hr.write(sw);
	  sw = !sw;
	}

        wait(2, SC_SEC); 
    }

  SC_CTOR(inputgen) 
    {
      SC_THREAD(generate);
    }
  


};
