//#define SC_INCLUDE_DYNAMIC_PROCESSES

// Number of generated inputes, change the command array when changing this value
#define INPUTSIZE 3
#define PEQENTRIES 4
// size of the data we want to send
#define INTSIZE 32

// enables some extra outputs, set to 0 for disabling
#define DEBUG 1

// needed as phase-arguments
#define INIT_REQ_PHASE 0
#define END_REQ_PHASE 1
#define INIT_RES_PHASE 2
#define END_RES_PHASE 3


#include <systemc.h>
//#include "data.h"
//typedef data int;
struct data
{
	//seems as if this has to be data, errors if not
     typedef data tlm_payload_type;
	//unused in our case but still necessary
  	typedef int tlm_phase_type;

	//containing the submitted value
	int val;

	//dummy methods for being able to compile
    bool has_mm() { return false; }
  	void set_mm(bool mm) { return; }
  	void set_auto_extension(void* x) { return; }
	//these seem to be used for a kind of pooling for payloads
	//we don't use it here
  	void acquire() { return; }
  	void release() { return; }
  	int get_ref_count() { return 1; }
  

};

// inlcude paths updated for systemc-2.3.0/TLM2
#include <tlm_2/tlm_sockets/tlm_initiator_socket.h>
#include <tlm_2/tlm_sockets/tlm_target_socket.h>
#include <peq_with_cb_and_phase.h>

//Module generating several read/write accesses to the memory
struct Producer : sc_module, tlm::tlm_bw_transport_if<data>
{

	//for using own datatypes we have to instantiate the initiator_socket with a Module, the size of the datatype we want to send over the socket, and the datatype we want to send.

	tlm::tlm_initiator_socket< INTSIZE, data, 1 > prod_socket;
	//initializing the PEQ
	tlm_utils::peq_with_cb_and_phase< Producer, data > prod_peq;

	data d;

	void prod_peq_cb(data& tran, const int& phase)
	{
	  	sc_time delay;
	  	int phase1;

	  	if (phase == END_REQ_PHASE) {
		  cout << "[" << sc_time_stamp() << "](Producer_cb): " << "Callback with END_REQ_PHASE for data " << tran.val << endl;
	  	}
	  	else if (phase == INIT_RES_PHASE) {
	  		cout << "[" << sc_time_stamp() << "](Producer_cb): " << "Callback with INIT_RES_PHASE and result " << tran.val << ". Preparing the response." << endl;
			cout << "[" << sc_time_stamp() << "](Producer_cb): " << "PEQ notify with data " << tran.val << " and delay 5 ns" << endl;
			prod_peq.notify(tran, END_RES_PHASE, sc_time(5, SC_NS)); //call this method again in 5 NS
	  	}
	  	else if (phase == END_RES_PHASE) {
	  		delay = sc_time(1, SC_NS);
	  		phase1 = END_RES_PHASE;
	  		cout << "[" << sc_time_stamp() << "](Producer_cb): " << "Callback with END_RES_PHASE. Sending " << tran.val << " to the consumer." << endl;
			prod_socket->nb_transport_fw(tran, phase1, delay);
		}
	}	


  	SC_CTOR(Producer)
			: prod_socket("prod_socket")  // Construct and name socket
			, prod_peq("prod_peq", this, &Producer::prod_peq_cb)
  	{
    	SC_THREAD(initiator_main);
		//binding the interface (in our case implemented by the Producer itself) to the socket 
	        // the socket now provides the nb_transport_bw function 
	        prod_socket.bind(*this);
  	}

  	void initiator_main()
  	{
	  sc_time transport_delay = sc_core::sc_time(5, SC_NS);
	  sc_time loop_delay = sc_time(20, SC_NS);
	  tlm::tlm_sync_enum se;
	  int i = 0,j = 0;
	       
	  while(true) 
	    for (i = 1; i <= INPUTSIZE; i++)
	      {

			if (DEBUG) cout << "[" << sc_time_stamp() << "](Producer_t): " << "Starting communication." << endl;
			int phase = INIT_REQ_PHASE;
			
			for (j = 1; j < PEQENTRIES; j = j + 1)
			  {
			    d.val = i + j;
			    cout << "[" << sc_time_stamp() << "](Producer_t): " << "Enqueueing in PEQ by calling nb_transport_fw ... " << endl; 
			    se = prod_socket->nb_transport_fw( d, phase, transport_delay );
			    wait(1,SC_NS);
			  }
			wait(1,SC_NS);
			se = prod_socket->nb_transport_fw( d, phase, transport_delay );
			//	cout << "[" << sc_time_stamp() << "](Producer_t): " << "nb_transport_fw returned, data is now " << d.val << endl;

			if (DEBUG) cout << "[" << sc_time_stamp() << "](Producer_t): " << "Communication finished. Target returned " << se << " and phase " << phase << "." << endl;

			// Realize the delay annotated onto the transport call
			//wait(loop_delay);
			cout << "[" << sc_time_stamp() << "](Producer_t): " << "Clearing PEQ by waiting 20 ns ... " << endl; 
			wait(50,SC_NS);
			cout << "[" << sc_time_stamp() << "](Producer_t): " << "phase is now " << phase << "." << endl;	
			//	wait(10, SC_NS);

			cout << "[" << sc_time_stamp() << "](Producer_t): " << "Finished iteration " << i+1 << "." << endl;	
			//		i = (i+1) % INPUTSIZE;

			
	      }
  	}

	//interface methods needed for tlm_bw_transport_if
	//this method is called by the target when it either has finished its work or needs something from the initiator
  	virtual void invalidate_direct_mem_ptr(sc_dt::uint64 start_range, sc_dt::uint64 end_range) {}

	tlm::tlm_sync_enum  nb_transport_bw(data& tran, int& phase, sc_time& t) 
	{
		cout << "[" << sc_time_stamp() << "](Producer_bw): " << "Received request with data " << tran.val << ", phase " << phase << " and delay " << t << ". Storing it in the Payload event queue and returning TLM_ACCEPTED." << endl;
		cout << "[" << sc_time_stamp() << "](Producer_bw): " << "PEQ notify with data " << tran.val << " and delay " << t << endl;
		prod_peq.notify(tran, phase, t);
		return tlm::TLM_ACCEPTED;	
	}

};


// Target module
struct Consumer : sc_module, tlm::tlm_fw_transport_if<data>
{

     	tlm::tlm_target_socket< INTSIZE, data, 1 > cons_socket;
  	tlm_utils::peq_with_cb_and_phase< Consumer, data > cons_peq;
  
      void cons_peq_cb(data& tran, const int& phase)
	{
	 	sc_time delay;
	 	int phase1;

		cout << "[" << sc_time_stamp() << "](Consumer_cb): " << "Callback with data " << tran.val << endl;

	 	if (phase == INIT_REQ_PHASE) {
	 		delay = sc_time(2, SC_NS);
	 		phase1 = END_REQ_PHASE;
	 		cout << "[" << sc_time_stamp() << "](Consumer_cb): " << "Sending data " << tran.val << " and END_REQ_PHASE to the Producer." << endl;
			cons_socket->nb_transport_bw(tran, phase1, delay);

			//	 		cout << "[" << sc_time_stamp() << "](Consumer_cb): " << "Waiting 5 NS to begin the response." << endl;
			cout << "[" << sc_time_stamp() << "](Consumer_cb): " << "PEQ notify with data " << tran.val << " and delay 5 ns" << endl;
	 		cons_peq.notify(tran, INIT_RES_PHASE, sc_time(5, SC_NS)); //call this method again in 5 NS
	 	}
	 	else if (phase == INIT_RES_PHASE) {
	 		delay = sc_time(2, SC_NS);
	 		phase1 = INIT_RES_PHASE;
	 		cout << "[" << sc_time_stamp() << "](Consumer_cb): " << "Sending data " << tran.val << "  INIT_RES_PHASE to the Producer." << endl;
			//	tran.val *= tran.val;			
	 		cons_socket->nb_transport_bw(tran, phase1, delay);
	 	}
	 	else if (phase == END_RES_PHASE) {
	 	  cout << "[" << sc_time_stamp() << "](Consumer_cb): " << "Receiving END_RES_PHASE from the Producer. Transport of data " << tran.val << " finished" << endl;
	 	}
	}

  //  data dc;
	SC_CTOR(Consumer)
		: cons_socket("cons_socket")
		, cons_peq("cons_peq", this, &Consumer::cons_peq_cb)			//register callback with PEQ (Payload event queue, see TLM LRM 9.3.1)
	{
	  //	  SC_THREAD(dummy);
		//binding the interface (in our case implemented by the Consumer itself) to the socket
	  		cons_socket.bind(*this);
	}

  // void dummy()
  // {
  //   int phase1 = 0;
  //   sc_time delay = sc_time(5,SC_NS);
  //   while(true){
  //     wait(10, SC_NS);
  // 	socket->nb_transport_bw(dc, phase1, delay);
  //   }
  // }

  	// TLM-2 blocking transport method

	// the work that should be done when a nb_transport is called from an initiator
  	tlm::tlm_sync_enum  nb_transport_fw(data& tran, int& phase, sc_time& t)
        {
  	   cout << "[" << sc_time_stamp() << "](Consumer_fw): " << "Received request with data " << tran.val << ", phase " << phase << " and delay " << t << ". Storing it in the Payload event queue and returning TLM_ACCEPTED." << endl;	

	   // tran.val = tran.val + 10;
	   //	   cout << "[" << sc_time_stamp() << "](Consumer_fw): data um 10 erhoeht, data ist jetzt: " << tran.val << endl;
	   cout << "[" << sc_time_stamp() << "](Consumer_fw): " << "PEQ notify with data " << tran.val << " and delay " << t << endl;
	   cons_peq.notify(tran, phase, t);
	   //  wait(1, SC_NS);
	   return tlm::TLM_ACCEPTED;		
	}

	// //dummy implementation
         virtual void b_transport( data& d, sc_time& delay ) {}
    virtual bool get_direct_mem_ptr(data& tran, tlm::tlm_dmi& dmi_data) { return false; }
  	virtual unsigned int transport_dbg(data& tran) { return 0; }
  
};


int sc_main(int argc, char* argv[])
{
  	Producer prod("p");
	Consumer cons("c");

	prod.prod_socket.bind( cons.cons_socket);	
	
	sc_start(1, SC_US);
  	return 0;
}

