/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sim.kascpar.util;

import de.fzi.sim.kascpar.util.RefInfo;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LineMapper {
    protected boolean m_isLineMapping = false;
    protected TreeMap m_lineDict = null;
    protected LinkedList m_gccErrStream;
    protected int DebugLevel = 0;
    protected String m_preprCmd;
    protected int m_os_id;
    protected Matcher matcherObsLM;
    protected Matcher matcherJumpLM;
    protected Matcher matcherInclLM;

    public LineMapper() {
        this.setPreprocessorCmd("g++ -E -C -w -H -nostdinc -nostdinc++ ");
        this.m_os_id = -1;
        Pattern pattern = Pattern.compile("# \\d+ \"<\\w+>\"( \\d+)?");
        Pattern pattern2 = Pattern.compile("# \\d+ \"[^\"]+\" [12]");
        Pattern pattern3 = Pattern.compile("# \\d+ \"[^\"]+\"");
        this.matcherObsLM = pattern.matcher("");
        this.matcherJumpLM = pattern3.matcher("");
        this.matcherInclLM = pattern2.matcher("");
    }

    public boolean lineMapping() {
        return this.m_isLineMapping;
    }

    public TreeMap lineDict() {
        return this.m_lineDict;
    }

    public void setDebugLevel(int n) {
        this.DebugLevel = n;
    }

    public void setPreprocessorCmd(String string) {
        this.m_preprCmd = string;
    }

    public void setOSId(int n) {
        this.m_os_id = n;
    }

    public boolean exec(LinkedList linkedList, File file, String string) {
        try {
            this.m_isLineMapping = false;
            this.m_lineDict = this.lineMapping(file.getAbsolutePath());
            if (this.m_lineDict == null) {
                this.m_isLineMapping = false;
            } else {
                this.m_isLineMapping = true;
                if (string != null) {
                    Set set = this.m_lineDict.entrySet();
                    FileWriter fileWriter = new FileWriter(new File(string));
                    fileWriter.write("----------------------------------------------------------------------------");
                    fileWriter.write("\n| Line  |  Orig.file    | line ");
                    fileWriter.write("\n----------------------------------------------------------------------------");
                    for (Map.Entry entry : set) {
                        fileWriter.write("\n| " + ((Integer)entry.getKey() + 1) + "  | " + ((RefInfo)entry.getValue()).file() + "  |  " + (((RefInfo)entry.getValue()).line() + 1));
                    }
                    set = this.m_lineDict.entrySet();
                    fileWriter.write("\n----------------------------------------------------------------------------\n");
                    fileWriter.write("real content of m_lineDict:\n");
                    fileWriter.write("----------------------------------------------------------------------------\n");
                    fileWriter.write("| m_line  |  m_file    | m_origLine \n");
                    fileWriter.write("----------------------------------------------------------------------------\n");
                    for (Map.Entry entry : set) {
                        fileWriter.write("\n| " + ((RefInfo)entry.getValue()).line() + "  | " + ((RefInfo)entry.getValue()).file() + "  |  " + ((RefInfo)entry.getValue()).origLine());
                    }
                    fileWriter.write("\nOK!");
                    fileWriter.close();
                }
            }
        }
        catch (IOException iOException) {
            System.err.println("Oops. " + iOException.getMessage());
            iOException.printStackTrace();
            return false;
        }
        catch (Exception exception) {
            System.err.println("Oops. " + exception.getMessage());
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    TreeMap lineMapping(String string) {
        String string2;
        BufferedWriter bufferedWriter;
        BufferedReader bufferedReader;
        File file = new File(string + ".line_mapper.tmp");
        file.deleteOnExit();
        File file2 = new File(string);
        String string3 = null;
        TreeMap<Integer, RefInfo> treeMap = new TreeMap<Integer, RefInfo>();
        boolean bl = false;
        int n = 1;
        int n2 = 0;
        try {
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
            bufferedReader = new BufferedReader(new FileReader(file2));
            bufferedWriter = new BufferedWriter(new FileWriter(file));
            while ((string2 = bufferedReader.readLine()) != null) {
                bufferedWriter.write(string2, 0, string2.length());
                bufferedWriter.newLine();
            }
            bufferedWriter.flush();
            bufferedWriter.close();
            bufferedReader.close();
        }
        catch (Exception exception) {
            System.err.println("ERROR: Can not copy common sourcefile, reason: " + exception.getMessage());
            exception.printStackTrace();
            return null;
        }
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
            file2.delete();
            file2.createNewFile();
            bufferedWriter = new BufferedWriter(new FileWriter(file2));
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.length() == 0) {
                    bufferedWriter.newLine();
                    treeMap.put(new Integer(n - 1), new RefInfo(string3, n, n2));
                    ++n;
                    ++n2;
                    continue;
                }
                if (string2.charAt(0) == '#') {
                    File file3;
                    String string4;
                    String string5;
                    String string6;
                    StringTokenizer stringTokenizer;
                    this.matcherObsLM.reset(string2);
                    this.matcherJumpLM.reset(string2);
                    this.matcherInclLM.reset(string2);
                    if (this.matcherObsLM.matches()) continue;
                    if (this.matcherInclLM.matches()) {
                        stringTokenizer = new StringTokenizer(string2);
                        if (stringTokenizer.countTokens() != 4) {
                            if (this.DebugLevel <= 0) continue;
                            System.out.println("Warning: include-linemarker with tokencount different from 4:");
                            System.out.println(string2);
                            continue;
                        }
                        string6 = stringTokenizer.nextToken();
                        string5 = stringTokenizer.nextToken();
                        string4 = stringTokenizer.nextToken();
                        String string7 = stringTokenizer.nextToken();
                        if (string7.matches("1")) {
                            bufferedWriter.newLine();
                            treeMap.put(new Integer(n - 1), new RefInfo(string3, n, n2));
                            ++n;
                        } else if (!string7.matches("2")) {
                            System.out.println("Unknown include-linemarker:");
                            System.out.println(string2);
                            continue;
                        }
                        n2 = Integer.parseInt(string5) - 1;
                        string3 = string4.substring(1, string4.length() - 1);
                        file3 = new File(string3);
                        if (!file3.exists()) continue;
                        string3 = file3.getAbsolutePath();
                        continue;
                    }
                    if (!this.matcherJumpLM.matches()) continue;
                    stringTokenizer = new StringTokenizer(string2);
                    if (stringTokenizer.countTokens() != 3) {
                        if (this.DebugLevel <= 0) continue;
                        System.out.println("Warning: jump-linemarker with tokencount different from 3:");
                        System.out.println(string2);
                        continue;
                    }
                    string6 = stringTokenizer.nextToken();
                    string5 = stringTokenizer.nextToken();
                    string4 = stringTokenizer.nextToken();
                    n2 = Integer.parseInt(string5) - 1;
                    string3 = string4.substring(1, string4.length() - 1);
                    file3 = new File(string3);
                    if (!file3.exists()) continue;
                    string3 = file3.getAbsolutePath();
                    continue;
                }
                bufferedWriter.write(string2);
                bufferedWriter.newLine();
                treeMap.put(new Integer(n - 1), new RefInfo(string3, n, n2));
                ++n2;
                ++n;
            }
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (Exception exception) {
            System.err.println("ERROR: Can not map lines, reason: " + exception.getMessage());
            exception.printStackTrace();
            return null;
        }
        return treeMap;
    }
}

